<?php
$fullDateTime = $row["ws_date"];
$dateOnly = date("d-m-Y", strtotime($fullDateTime));

$stime = $row["ws_startTime"];
$stime = date("h:i A", strtotime($stime));

$etime = $row["ws_endTime"];
$etime = date("h:i A", strtotime($etime));

$currentDateTime = new DateTime();
$sessionDate = new DateTime($fullDateTime);

$sessionStartDateTime = new DateTime($fullDateTime . ' ' . $stime);
$sessionEndDateTime = new DateTime($fullDateTime . ' ' . $etime);

$wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '$row[ws_id]' ");
$total = 0;
$completed = 0;

while ($wl_r = mysqli_fetch_assoc($wl_sql)) {
    $total++;
    if ($wl_r['wl_status'] == 1) {
        $completed++;
    }
}

if ($currentDateTime < $sessionStartDateTime) {
    $status = "Upcoming";
    $badgeClass = "bg-info";
} elseif ($currentDateTime >= $sessionStartDateTime && $currentDateTime <= $sessionEndDateTime) {
    $status = "Ongoing";
    $badgeClass = "bg-warning";
} elseif ($currentDateTime > $sessionEndDateTime) {
    if ($total == 0) {
        $status = "Incomplete";
        $badgeClass = "bg-danger";
    } elseif ($completed == $total) {
        $status = "Completed";
        $badgeClass = "bg-success";
    } elseif ($completed > 0) {
        $status = "Partially Completed";
        $badgeClass = "bg-primary";
    } else {
        $status = "Incomplete";
        $badgeClass = "bg-danger";
    }
} else {
    $status = "Unknown";
    $badgeClass = "bg-secondary";
}
?>

<div class="accordion mb-3">
    <div class="heading text-white p-2 rounded-3 d-flex justify-content-between align-items-center shadow-sm">
        <div class="d-flex align-items-center">
            <h5 class="mb-0 fw-semibold">
                <i class="fa-solid fa-calendar-day me-1"></i> <?= $dateOnly ?>
            </h5> &nbsp; &nbsp;
            <small class="">
                <i class="fa-solid fa-clock me-1"></i> <?= $stime ?> - <?= $etime ?>
            </small>
        </div>
        <div class="text-end">
            <span class="badge <?= $badgeClass ?> me-2"><?= $status ?></span>
            <?php if (!empty($row["ws_workPercent"])): ?>
            <span class="badge bg-secondary">Progress: <?= $row["ws_workPercent"] ?>%</span>
            <?php endif; ?>
        </div>
    </div>

    <div class="contents p-3 border rounded-bottom bg-white shadow-sm" style="display: none;">
        <div class="d-flex justify-content-end mb-3">
            <button type="button" class="btn btn-sm btn-primary openRemarkModal" data-id="<?= $row['ws_id']; ?>">
                <i class="fa-solid fa-pen-to-square me-1"></i> Submit Remark
            </button>
        </div>

        <?php 
        $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '$row[ws_id]' ");
        $a = 1;
        if (mysqli_num_rows($wl_sql) > 0):
            while($wl_row = mysqli_fetch_assoc($wl_sql)): 
        ?>
        <div class="card border-0 mb-3" style="background: #f8faff;">
            <div class="card-body py-2">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h6 class="m-0 fw-semibold">
                        <span class="text-primary"><?= $a . ') '; ?></span>
                        <?= htmlspecialchars($wl_row["wl_title"]); ?>
                        <?php if($wl_row["wl_status"] == '1'): ?>
                        <span class="badge bg-success ms-2"><i class="fa-solid fa-check me-1"></i> Completed</span>
                        <?php else: ?>
                        <span class="badge bg-danger ms-2"><i class="fa-solid fa-hourglass-half me-1"></i>
                            Pending</span>
                        <?php endif; ?>
                    </h6>
                    <div class="form-check form-switch m-0">
                        <input class="form-check-input toggleStatus" type="checkbox" data-id="<?= $wl_row['wl_id']; ?>"
                            <?= ($wl_row["wl_status"] == '1') ? 'checked' : ''; ?>>
                    </div>
                </div>
                <div class="text-muted small">
                    <?= $wl_row["wl_des"]; ?>
                </div>
            </div>
        </div>
        <?php 
            $a++;
            endwhile;
        else:
            echo "<div class='alert alert-warning mb-0'>No work items available.</div>";
        endif;
        ?>
    </div>
</div>