<?php
include "./include/header.php";
if ($_SESSION['utype'] !== 'employee') {
    header("Location: ../login.php");
    exit;
}

$uid = $_SESSION['uid'];
$today = date('Y-m-d');
?>

<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0"><i class="fa fa-calendar-check me-2 text-primary"></i>My Attendance</h5>
                <button class="btn btn-success" onclick="openFaceVerifyModal()">
                    <i class="fa fa-user-check me-1"></i> Verify Face & Start Attendance
                </button>
            </div>

            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Date</th>
                                    <th>Check-In</th>
                                    <th>Check-Out</th>
                                    <th>Status</th>
                                    <th>Remarks</th>
                                    <th>Overtime</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $sql = $con->prepare("SELECT * FROM attendance WHERE user_id = ? ORDER BY date DESC");
                                    $sql->bind_param("i", $uid);
                                    $sql->execute();
                                    $result = $sql->get_result();
                                    $i = 1;

                                    if ($result->num_rows > 0):
                                        while ($row = $result->fetch_assoc()):

                                            // Status badge
                                            $badgeClass = match ($row['status']) {
                                                'Present' => 'success',
                                                'Late'    => 'warning',
                                                'Absent'  => 'danger',
                                                default   => 'secondary'
                                            };

                                            // Overtime minutes
                                            $overtime = $row['overtime_minutes'] ? $row['overtime_minutes'] . ' min' : '-';
                                ?>
                                <tr>
                                    <td><?= $i ?></td>

                                    <td><?= htmlspecialchars($row['date']) ?></td>

                                    <td><?= $row['check_in'] ?: '-' ?></td>

                                    <td><?= $row['check_out'] ?: '-' ?></td>

                                    <td>
                                        <span class="badge bg-<?= $badgeClass ?>">
                                            <?= htmlspecialchars($row['status']) ?>
                                        </span>
                                    </td>

                                    <td><?= htmlspecialchars($row['remarks'] ?: '-') ?></td>

                                    <td><?= $overtime ?></td>

                                    <td>
                                        <?php if (empty($row['check_out'])): ?>
                                        <button class="btn btn-sm btn-danger checkout-btn"
                                            data-id="<?= $row['att_id'] ?>" title="Check Out">
                                            <i class="fa fa-sign-out-alt"></i>
                                        </button>
                                        <?php else: ?>
                                        <span class="text-muted small">Completed</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php
                                            $i++;
                                        endwhile;
                                    else:
                                ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">
                                        No attendance records found.
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>

        </div>

        <!-- Face Verify Modal -->
        <div class="modal fade" id="faceVerifyModal" tabindex="-1">
            <div class="modal-dialog modal-dialog-centered modal-md">
                <div class="modal-content">
                    <div class="modal-header bg-primary text-white">
                        <h6 class="mb-0"><i class="fa fa-face-smile"></i> Face Verification</h6>
                        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body text-center">
                        <!-- LIVENESS CHALLENGE DISPLAY -->
                        <div id="livenessBox" class="alert alert-warning fw-bold mb-2" style="font-size:16px">
                            Initializing liveness check...
                        </div>

                        <!-- CAMERA -->
                        <video id="video" width="100%" autoplay muted class="rounded border"></video>

                        <!-- LIVE STATUS -->
                        <div id="faceStatus" class="mt-2 fw-semibold text-primary">Please look straight</div>

                        <!-- BLINK PROGRESS -->
                        <div id="blinkProgress" class="small text-muted mt-1">Blink: 0 / 0</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- CHECKOUT MODAL -->
        <div class="modal fade" id="checkoutModal" tabindex="-1" aria-labelledby="checkoutModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-md modal-dialog-centered">
                <div class="modal-content shadow">

                    <div class="modal-header">
                        <h6 class="modal-title" id="checkoutModalLabel">
                            <i class="fa fa-sign-out-alt text-danger me-1"></i>
                            Confirm Check-Out
                        </h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <input type="hidden" id="checkoutAttId">

                        <label class="form-label small fw-semibold">Remarks (optional)</label>
                        <textarea id="checkoutRemark" class="form-control form-control-sm" rows="2"
                            placeholder="Any remarks..."></textarea>

                        <div class="alert alert-light mt-3 p-2 small mb-0 d-none">
                            <i class="fa fa-map-marker-alt text-danger"></i>
                            Your current location will be recorded.
                        </div>
                    </div>

                    <div class="modal-footer py-2">
                        <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">
                            Cancel
                        </button>

                        <button type="button" class="btn btn-sm btn-danger" id="confirmCheckout">
                            <i class="fa fa-check"></i> Confirm
                        </button>
                    </div>

                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/@tensorflow/tfjs"></script>
<script src="https://cdn.jsdelivr.net/npm/@tensorflow-models/blazeface"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
/* ================= ELEMENTS ================= */
const video = document.getElementById("video");
const livenessBox = document.getElementById("livenessBox");
const faceStatus = document.getElementById("faceStatus");
const blinkProgress = document.getElementById("blinkProgress");

/* ================= GLOBALS ================= */
let stream = null;
let model = null;
let detectInterval = null;

let storedFaceBox = null;
let baseLiveBox = null;

let verified = false;
let challenge = null;

/* ================= LOAD MODEL ================= */
async function loadFaceModel() {
    if (model) return;
    model = await blazeface.load();
}

/* ================= OPEN MODAL ================= */
async function openFaceVerifyModal() {
    await loadFaceModel();

    const modal = new bootstrap.Modal(
        document.getElementById("faceVerifyModal")
    );
    modal.show();

    await startCamera();
    await startVerification();
}

/* ================= CAMERA ================= */
async function startCamera() {
    if (stream) return;

    stream = await navigator.mediaDevices.getUserMedia({
        video: {
            facingMode: "user"
        },
        audio: false
    });

    video.srcObject = stream;

    return new Promise(resolve => {
        video.onloadedmetadata = () => {
            video.play();
            resolve();
        };
    });
}

function stopCamera() {
    if (stream) {
        stream.getTracks().forEach(t => t.stop());
        stream = null;
    }
}

/* ================= LOAD STORED FACE ================= */
async function loadStoredFaceImage() {
    const res = await fetch("ajax/get_face_descriptor.php", {
        credentials: "same-origin"
    });

    const txt = await res.text();

    if (txt === "NO_FACE") throw "Face not registered";
    if (txt === "UNAUTHORIZED") throw "Unauthorized";

    return txt;
}

/* ================= DETECT FACE FROM IMAGE ================= */
async function detectFaceFromImage(imgPath) {
    const img = new Image();
    img.src = imgPath;
    await img.decode();

    const preds = await model.estimateFaces(img, false);

    if (preds.length !== 1) {
        throw "Invalid stored face image";
    }

    return preds[0];
}

/* ================= FACE SIMILARITY ================= */
function faceBoxSimilar(a, b) {
    const aw = a.bottomRight[0] - a.topLeft[0];
    const ah = a.bottomRight[1] - a.topLeft[1];
    const bw = b.bottomRight[0] - b.topLeft[0];
    const bh = b.bottomRight[1] - b.topLeft[1];

    const ratioDiff = Math.abs((aw / ah) - (bw / bh));
    const areaDiff = Math.abs((aw * ah) - (bw * bh)) / (aw * ah);

    return ratioDiff < 0.25 && areaDiff < 0.4;
}

/* ================= HEAD CHALLENGE ================= */
function generateChallenge() {
    const list = ["LEFT", "RIGHT", "UP", "DOWN"];
    challenge = list[Math.floor(Math.random() * list.length)];

    livenessBox.className = "alert alert-warning fw-bold";
    livenessBox.innerText = `🧠 Turn your head ${challenge}`;

    blinkProgress.innerText = "";
}

function headMoved(base, current) {
    const dx = current.topLeft[0] - base.topLeft[0];
    const dy = current.topLeft[1] - base.topLeft[1];

    if (challenge === "LEFT" && dx < -12) return true;
    if (challenge === "RIGHT" && dx > 12) return true;
    if (challenge === "UP" && dy < -12) return true;
    if (challenge === "DOWN" && dy > 12) return true;

    return false;
}

/* ================= VERIFICATION LOOP ================= */
async function startVerification() {
    try {
        const imgPath = await loadStoredFaceImage();
        storedFaceBox = await detectFaceFromImage(imgPath);
    } catch (e) {
        alert(e);
        stopAll();
        return;
    }

    generateChallenge();

    detectInterval = setInterval(async () => {

        if (verified || video.readyState < 3) return;

        const preds = await model.estimateFaces(video, false);

        if (preds.length === 0) {
            faceStatus.innerText = "No face detected";
            return;
        }

        if (preds.length > 1) {
            faceStatus.innerText = "Multiple faces detected";
            return;
        }

        const liveBox = preds[0];

        if (!faceBoxSimilar(storedFaceBox, liveBox)) {
            faceStatus.innerText = "Face mismatch";
            return;
        }

        faceStatus.innerText = "Hold still…";

        if (!baseLiveBox) {
            baseLiveBox = liveBox;
            return;
        }

        if (headMoved(baseLiveBox, liveBox)) {
            verified = true;
            verificationSuccess();
        }

    }, 200);
}

/* ================= SUCCESS ================= */
function verificationSuccess() {
    clearInterval(detectInterval);

    livenessBox.className = "alert alert-success fw-bold";
    livenessBox.innerText = "✅ Face Verified";

    setTimeout(() => {
        stopAll();
        if (typeof initAttendanceTracking === "function") {
            initAttendanceTracking();
        }
    }, 800);
}

/* ================= STOP ALL ================= */
function stopAll() {
    clearInterval(detectInterval);
    detectInterval = null;
    verified = false;
    baseLiveBox = null;
    stopCamera();

    const modalEl = document.getElementById("faceVerifyModal");
    const modal = bootstrap.Modal.getInstance(modalEl);
    if (modal) modal.hide();
}
</script>

<script>
let checkoutModal;

document.addEventListener("DOMContentLoaded", () => {
    checkoutModal = new bootstrap.Modal(document.getElementById('checkoutModal'));
});

// Open modal
document.addEventListener('click', function(e) {
    const btn = e.target.closest('.checkout-btn');
    if (!btn) return;

    document.getElementById('checkoutAttId').value = btn.dataset.id;
    document.getElementById('checkoutRemark').value = '';
    checkoutModal.show();
});

// Confirm checkout
document.getElementById('confirmCheckout').addEventListener('click', function() {

    const attId = document.getElementById('checkoutAttId').value;
    const remark = document.getElementById('checkoutRemark').value;

    if (!navigator.geolocation) {
        alert("GPS not supported");
        return;
    }

    navigator.geolocation.getCurrentPosition(
        pos => {
            sendCheckout(
                attId,
                remark,
                pos.coords.latitude,
                pos.coords.longitude,
                0
            );
        },
        () => alert("Unable to fetch location"), {
            enableHighAccuracy: true,
            timeout: 15000
        }
    );
});

// AJAX
function sendCheckout(attId, remark, lat, lng, auto = 0) {

    fetch("checkout_action.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded"
            },
            body: new URLSearchParams({
                att_id: attId,
                remark: remark,
                latitude: lat,
                longitude: lng,
                auto: auto
            })
        })
        .then(res => res.text())
        .then(msg => {
            alert(msg);
            location.reload();
        })
        .catch(() => alert("Checkout failed"));
}
</script>



<?php include('./include/js.php'); ?>