<?php
session_start();
include "../config/db.php";
include "../config/constants.php";
date_default_timezone_set("Asia/Kolkata");

if (!isset($_SESSION['uid'])) {
    http_response_code(403);
    exit;
}

$user_id = $_SESSION['uid'];
$org_id  = $_SESSION['uref'];
$date    = date('Y-m-d');
$now     = date('Y-m-d H:i:s');
$nowTime = date('H:i:s');

$lat = $_POST['latitude'] ?? null;
$lng = $_POST['longitude'] ?? null;

/* FETCH USER DATA */
$userQ = mysqli_query($con, "SELECT emp_shift, emp_offDay, utypeorg, admin_ref FROM users WHERE uid='$user_id'");
$user = mysqli_fetch_assoc($userQ);

$get_admin = mysqli_query($con, "SELECT * FROM users WHERE uref = '{$user["admin_ref"]}' ");
$admin_row = mysqli_fetch_assoc($get_admin);
$admin_id = $admin_row["uid"];
$admin_lat = $admin_row["latitude"];
$admin_long = $admin_row["longitude"];

/* OFF DAY CHECK */
$today = date('l'); // Monday, Tuesday
$offDays = array_map('trim', explode(',', $user['emp_offDay']));

if (in_array($today, $offDays)) {
    exit("OFF_DAY");
}

/* LEAVE CHECK */
$leaveQ = mysqli_query($con, "SELECT * FROM leaves WHERE user_id='$user_id' AND status='Approved' AND '$date' BETWEEN start_date AND end_date");

if (mysqli_num_rows($leaveQ) > 0) {
    exit("ON_LEAVE");
}

/*  DESIGNATION CHECK  */
$desigQ = mysqli_query($con, "SELECT d_name FROM designation WHERE d_id='{$user['utypeorg']}'");
$desig = mysqli_fetch_assoc($desigQ);
$marketingRoles = [
    'Marketing Manager',
    'Marketing Executive',
    'marketing'
];

$isMarketing = false;
foreach ($marketingRoles as $role) {
    if (stripos($desig['d_name'], $role) !== false) {
        $isMarketing = true;
        break;
    }
}

/* DUPLICATE CHECK */
$checkQ = mysqli_query($con, "SELECT * FROM attendance WHERE user_id='$user_id' AND date='$date' ");

if (mysqli_num_rows($checkQ) > 0) {

    if ($isMarketing) {
        exit("START_GPS_MARKETING");
    } else {
        exit("START_GPS_NON_MARKETING");
    }
}

/* SHIFT LOGIC */
list($shiftStart, $shiftEnd) = explode('-', $user['emp_shift']);

$shiftStartTime = date("H:i:s", strtotime($shiftStart));
$shiftEndTime   = date("H:i:s", strtotime($shiftEnd));

$earlyLimit = date("H:i:s", strtotime($shiftStartTime . " -20 minutes"));
$lateLimit  = date("H:i:s", strtotime($shiftStartTime . " +30 minutes"));

if ($nowTime < $earlyLimit || $nowTime > $lateLimit) {
    exit("CHECKIN_TIME_NOT_ALLOWED");
}

$halfDayLimit  = date("H:i:s", strtotime($shiftStartTime . " +15 minutes"));
$checkoutLimit = date("H:i:s", strtotime($shiftEndTime   . " +20 minutes"));
$overtimeLimit = date("H:i:s", strtotime($shiftEndTime   . " +30 minutes"));

if ($nowTime <= $shiftStartTime) {
    $status = "Present";
    $half_day = 0;
} elseif ($nowTime > $halfDayLimit) {
    $status = "Half Day";
    $half_day = 1;
} else {
    $status = "Late";
    $half_day = 0;
}

/*  GEO DISTANCE (NON MARKETING)  */
function distance($lat1, $lon1, $lat2, $lon2) {
    $earth = 6371000;
    $dLat = deg2rad($lat2-$lat1);
    $dLon = deg2rad($lon2-$lon1);
    $a = sin($dLat/2)**2 +
         cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
         sin($dLon/2)**2;
    return $earth * (2 * asin(sqrt($a)));
}

if (!$isMarketing) {
    if (!$lat || !$lng) exit("NO_GPS");

    $dist = distance($lat, $lng, $admin_lat, $admin_long);
    if ($dist > 100) exit("OUTSIDE_OFFICE");
}

$shift_time = $user['emp_shift'];

/*  INSERT ATTENDANCE  */
$stmt = $con->prepare("INSERT INTO attendance (user_id, date, check_in, status, half_day, shift_time, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
$stmt->bind_param("isssi", $user_id, $date, $now, $status, $half_day, $shift_time);
$stmt->execute();

echo $isMarketing ? "START_GPS_MARKETING" : "START_GPS_NON_MARKETING";