<?php
session_start();
include "../config/db.php";

if (!isset($_SESSION['uid'])) {
    http_response_code(403);
    echo "Unauthorized";
    exit;
}

$uid = (int)$_SESSION['uid'];
$att_id = isset($_POST['att_id']) ? (int)$_POST['att_id'] : 0;
$remark = $_POST['remark'] ?? '';
$lat = $_POST['latitude'] ?? '';
$lng = $_POST['longitude'] ?? '';
$auto = isset($_POST['auto']) && $_POST['auto'] == '1' ? 1 : 0;

// input validation
if (!$att_id) {
    echo "Missing attendance id.";
    exit;
}

// ensure this attendance belongs to this user and is open
$sel = $con->prepare("SELECT * FROM attendance WHERE att_id = ? AND user_id = ? LIMIT 1");
$sel->bind_param("ii", $att_id, $uid);
$sel->execute();
$r = $sel->get_result();
if (!$r || $r->num_rows == 0) {
    echo "Invalid attendance record.";
    exit;
}
$row = $r->fetch_assoc();
if (!empty($row['check_out'])) {
    echo "Already checked out.";
    exit;
}

// get working_end_time for overtime calc
$workEnd = '18:00:00';
$q = $con->query("SELECT setting_key, setting_value FROM leave_settings WHERE setting_key='working_end_time'");
if ($q && $rr = $q->fetch_assoc()) $workEnd = $rr['setting_value'];

$endTs = strtotime($workEnd);
$nowTs = time();
$bufferEnd = $endTs + (20 * 60);

// compute overtime minutes
$overtimeMinutes = 0;
if ($nowTs > $bufferEnd) {
    $overtimeMinutes = intval(($nowTs - $endTs) / 60);
}

// update attendance
$upd = $con->prepare("UPDATE attendance SET check_out = NOW(), remarks = ?, overtime_minutes = ?, checkout_lat = ?, checkout_lng = ?, auto_checkout = ? WHERE att_id = ? AND user_id = ?");
$upd->bind_param("siisiii", $remark, $overtimeMinutes, $lat, $lng, $auto, $att_id, $uid);
if ($upd->execute()) {
    if ($auto) {
        echo "Auto checkout recorded (att_id: {$att_id}).";
    } else {
        echo "Checkout recorded successfully.";
    }
} else {
    echo "Failed to record checkout.";
}