<?php
include('./include/header.php');

$uid = $_SESSION['uid'];
$admin_ref = mysqli_query($con, "SELECT * FROM users WHERE uid = '$uid' ");
$admin_row = mysqli_fetch_assoc($admin_ref);
$admin_ref = $admin_row["admin_ref"];

// fetch org id
$orgRow = mysqli_fetch_assoc(mysqli_query($con,"SELECT uid FROM users WHERE uref='$admin_ref'" ));
$org_id = $orgRow['uid'];

$user = $con->query("SELECT * FROM users WHERE uid = '$uid'")->fetch_assoc();

// Current Year
$currentYear = date("Y");
$today = date("Y-m-d");

// Get weekly off and half-day selections
$days = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday'];
$selectedOff = json_encode(array_map('trim', explode(',', $admin_row['emp_offDay'])));
$halfSelected = json_encode(array_map('trim', explode(',', $admin_row['emp_halfDay'] ?? '')));

// $selectedOff = array_filter(array_map('trim', explode(',', getSetting('weekly_off'))));
// $halfSelected = array_filter(array_map('trim', explode(',', getSetting('is_half_day'))));

// Fetch all holidays from DB (we'll use them client-side to filter by visible month/year)
// Expect columns: id, holiday_name, holiday_date (Y-m-d)
$all_holidays_q = $con->query("SELECT id, holiday_name, holiday_date FROM holiday_list WHERE holiday_for = '$org_id' ORDER BY holiday_date ASC");
$all_holidays = [];
while ($r = $all_holidays_q->fetch_assoc()) {
    $all_holidays[] = $r;
}
?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <h4 id="pageTitle" class="fw-bold mb-3">
                <i class="fa fa-calendar me-2"></i> Holiday Calendar - <span
                    id="pageYear"><?= htmlspecialchars($currentYear) ?></span>
            </h4>

            <!-- CALENDAR + RIGHT LIST -->
            <div class="row g-4">
                <div class="col-lg-8">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <div class="d-block d-lg-flex justify-content-between align-items-center mb-3">
                                <h5 class="fw-bold text-primary mb-lg-0 mb-0">
                                    <i class="fa fa-hashtag me-2"></i> Holidays & Offs
                                </h5>
                                <div>
                                    <small class="text-muted">Legend: <span class="badge"
                                            style="background:#198754">Holiday</span> <span class="badge"
                                            style="background:#dc3545">Weekly Off</span> <span class="badge"
                                            style="background:#ffc107;color:#000">Half Day</span></small>
                                </div>
                            </div>

                            <div id="holidayCalendar" class="border rounded p-2" style="min-height:560px;"></div>
                        </div>
                    </div>
                </div>

                <!-- RIGHT: Search + Holiday list for visible month/year -->
                <div class="col-lg-4">
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <h5 class="fw-bold text-primary mb-3"><i class="fa fa-search me-2"></i> Search Holidays (in
                                visible month)</h5>

                            <input id="searchInput" type="text" class="form-control mb-3"
                                placeholder="Search holiday name...">

                            <h6 class="fw-bold text-secondary">Holidays this month</h6>
                            <div id="visibleHolidays" class="list-group mt-2" style="max-height:500px;overflow:auto;">
                                <!-- Populated by JS when calendar view changes -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php include('./include/footer.php'); ?>
        </div>
    </div>
</div>

<!-- FullCalendar -->
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>

<!-- Font Awesome (if needed) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
    crossorigin="anonymous" />

<style>
/* Event dot style (B) and pill style (A) */
.fc .fc-event {
    border: none;
    border-radius: 6px;
    padding: 2px 6px;
    font-size: 12px;
    box-shadow: none;
}

/* Add small colored dot before event title */
.fc .fc-event .ev-dot {
    display: inline-block;
    width: 8px;
    height: 8px;
    border-radius: 50%;
    margin-right: 6px;
    vertical-align: middle;
}

/* half-day dashed border variant */
.fc .fc-event.half-day {
    border: 2px dashed rgba(0, 0, 0, 0.12);
    background-clip: padding-box;
}

/* make holiday list items look nice */
#visibleHolidays .list-group-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

/* Mobile View */
@media (max-width: 576px) {
    .fc .fc-toolbar {
        display: block !important;
    }

    /* Center the navigation buttons */
    .fc .fc-toolbar-chunk {
        margin-bottom: 8px;
    }

    .fc .fc-button {
        border-radius: 0.25em;
        display: inline-block;
        font-size: 1em;
        font-weight: 400;
        line-height: 1.5;
        padding: 0.2em 0.5em;
        text-align: center;
        user-select: none;
        vertical-align: middle;
    }
}
</style>

<script>
/* Prepare data from PHP */
var dbHolidays = <?= json_encode($all_holidays, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_QUOT|JSON_HEX_AMP) ?>;

// Weekly off and half-day arrays from PHP
var weeklyOffDays = <?= $selectedOff ?>; // names like "Sunday"
var halfDayDays = <?= $halfSelected ?>; // names like "Wednesday"

/* Map weekday name to numeric day (0=Sun..6=Sat) */
var weekdayMap = {
    'Sunday': 0,
    'Monday': 1,
    'Tuesday': 2,
    'Wednesday': 3,
    'Thursday': 4,
    'Friday': 5,
    'Saturday': 6
};

/* Colors for types */
var colors = {
    holiday: '#198754', // green
    weekly_off: '#dc3545', // red
    half_day: '#ffc107' // yellow
};

/* Build events list for a 3-year span (currentYear-1 .. currentYear+1)
   so user navigation around years shows weekly offs/half-days as events.
*/
var events = [];

// 1) Add DB holidays as events (type = 'holiday')
dbHolidays.forEach(function(h) {
    events.push({
        id: 'h_' + h.id,
        title: h.holiday_name,
        start: h.holiday_date,
        allDay: true,
        extendedProps: {
            type: 'holiday'
        },
        backgroundColor: colors.holiday,
        borderColor: colors.holiday,
        textColor: '#fff'
    });
});

// 2) For weekly offs and half-days, generate events for a range of dates
var curYear = new Date().getFullYear();
var startYear = curYear - 1;
var endYear = curYear + 1;

function addDateEvent(dateStr, opts) {
    // avoid duplicates: events with same title and date - keep all anyway
    events.push(Object.assign({
        title: opts.title,
        start: dateStr,
        allDay: true,
        extendedProps: {
            type: opts.type
        }
    }, opts.renderStyles || {}));
}

// iterate each date in range
function iterateDates(fromY, toY, cb) {
    var from = new Date(fromY, 0, 1);
    var to = new Date(toY, 11, 31);
    for (var d = new Date(from); d <= to; d.setDate(d.getDate() + 1)) {
        cb(new Date(d));
    }
}

iterateDates(startYear, endYear, function(d) {
    var weekdayName = d.toLocaleString('en-US', {
        weekday: 'long'
    }); // Monday etc

    // weekly off
    if (weeklyOffDays.indexOf(weekdayName) !== -1) {
        var ds = d.toISOString().slice(0, 10);
        addDateEvent(ds, {
            title: 'Weekly Off',
            type: 'weekly_off',
            renderStyles: {
                backgroundColor: colors.weekly_off,
                borderColor: colors.weekly_off,
                textColor: '#fff'
            }
        });
    }

    // half-day
    if (halfDayDays.indexOf(weekdayName) !== -1) {
        var ds2 = d.toISOString().slice(0, 10);
        addDateEvent(ds2, {
            title: 'Half Day',
            type: 'half_day',
            renderStyles: {
                backgroundColor: colors.half_day,
                borderColor: colors.half_day,
                textColor: '#000'
            }
        });
    }
});

/* Initialize FullCalendar */
document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('holidayCalendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        height: 560,
        events: events,
        headerToolbar: {
            left: 'prevYear,prev,next,nextYear today',
            center: 'title',
            right: ''
        },
        displayEventTime: false,
        eventClassNames: function(arg) {
            // add class for half-day dashed border
            if (arg.event.extendedProps && arg.event.extendedProps.type === 'half_day') return [
                'half-day'
            ];
            return [];
        },
        eventDidMount: function(info) {
            // add dot + keep title (A + B + C)
            var type = info.event.extendedProps && info.event.extendedProps.type ? info.event
                .extendedProps.type : 'holiday';
            var dot = document.createElement('span');
            dot.className = 'ev-dot';
            dot.style.background = (type === 'holiday' ? colors.holiday : (type === 'weekly_off' ?
                colors.weekly_off : colors.half_day));
            // Insert dot before title text
            var fcTitle = info.el.querySelector('.fc-event-title');
            if (fcTitle) {
                fcTitle.prepend(dot);
            } else {
                // fallback: prepend to element
                info.el.prepend(dot);
            }
        },
        datesSet: function(rangeInfo) {
            // Called when the current view changes (month/year navigation)
            var start = rangeInfo.start; // Date object at beginning of view
            // update page title year dynamically based on current view's center date
            var center = calendar.getDate(); // returns a Date in the current view
            var viewYear = center.getFullYear();
            document.getElementById('pageYear').innerText = viewYear;

            // update visible holidays list for the month/year in view
            updateVisibleHolidayList(center);
        }
    });

    calendar.render();

    // initial visible list load
    updateVisibleHolidayList(calendar.getDate());

    // Search box filter (search within visible list)
    document.getElementById('searchInput').addEventListener('input', function() {
        var q = this.value.trim().toLowerCase();
        document.querySelectorAll('#visibleHolidays .list-group-item').forEach(function(li) {
            var name = li.getAttribute('data-name') || '';
            li.style.display = (name.indexOf(q) !== -1) ? '' : 'none';
        });
    });

    // Function to update right-side holiday list based on visible month & year
    function updateVisibleHolidayList(centerDate) {
        var month = centerDate.getMonth() + 1; // 1..12
        var year = centerDate.getFullYear();

        var container = document.getElementById('visibleHolidays');
        container.innerHTML = '';

        // Filter DB holidays (only show DB holidays here) for the same month/year
        var filtered = dbHolidays.filter(function(h) {
            var d = new Date(h.holiday_date);
            return (d.getFullYear() === year && (d.getMonth() + 1) === month);
        });

        if (filtered.length === 0) {
            var empty = document.createElement('div');
            empty.className = 'text-muted small';
            empty.innerText = 'No holidays in this month.';
            container.appendChild(empty);
            return;
        }

        filtered.forEach(function(h) {
            var li = document.createElement('a');
            li.className = 'list-group-item list-group-item-action';
            li.href = 'javascript:void(0)';
            li.setAttribute('data-name', (h.holiday_name || '').toLowerCase());

            var left = document.createElement('div');
            left.innerHTML = '<div class="fw-bold">' + escapeHtml(h.holiday_name) +
                '</div><small class="text-muted">' + formatDate(h.holiday_date) + '</small>';

            li.appendChild(left);
            container.appendChild(li);
        });

        // apply current search filter if any
        var q = document.getElementById('searchInput').value.trim().toLowerCase();
        if (q) {
            document.querySelectorAll('#visibleHolidays .list-group-item').forEach(function(li) {
                var name = li.getAttribute('data-name') || '';
                li.style.display = name.indexOf(q) !== -1 ? '' : 'none';
            });
        }
    }

    // helpers
    function formatDate(dstr) {
        var d = new Date(dstr);
        var opts = {
            day: '2-digit',
            month: 'short',
            year: 'numeric'
        };
        return d.toLocaleDateString('en-US', opts);
    }

    function escapeHtml(s) {
        if (!s) return '';
        return s.replace(/[&<>"']/g, function(m) {
            return ({
                '&': '&amp;',
                '<': '&lt;',
                '>': '&gt;',
                '"': '&quot;',
                "'": '&#39;'
            })[m];
        });
    }
});
</script>

<?php include('./include/js.php'); ?>