<style>
/* Collapsible Sidebar Styling */
.sidebar {
    width: 250px;
    transition: width 0.3s ease;
    overflow-x: hidden;
    position: relative;
}

/* Links layout */
.sidebar .nav-link {
    display: flex;
    align-items: center;
    gap: 10px;
    transition: all 0.3s ease;
    white-space: nowrap;
}

/* Text spans (menu labels) */
.sidebar .nav-link span,
.sidebar .sidebar-logo span,
.sidebar .mt-auto span {
    opacity: 1;
    visibility: visible;
    transition: opacity 0.3s ease, visibility 0.3s ease;
}

/* Collapsed sidebar */
.sidebar.collapsed {
    width: 80px;
}

/* Hide text smoothly */
.sidebar.collapsed .nav-link span,
.sidebar.collapsed .sidebar-logo span,
.sidebar.collapsed .mt-auto span {
    opacity: 0;
    visibility: hidden;
    width: 0;
    overflow: hidden;
    transition: opacity 0.2s ease, width 0.3s ease;
}

.sidebar.collapsed .nav-link {
    /* padding-left: 0; */
}

.sidebar.collapsed .sidebar-logo {
    display: none !important;
}

/* Center icons in collapsed mode */
.sidebar.collapsed .nav-link {
    justify-content: center;
    gap: 0;
    text-align: center;
}

/* Adjust icon spacing */
.sidebar .nav-link i {
    width: 20px;
    text-align: center;
    transition: all 0.3s ease;
}

/* Sidebar brand/logo alignment */
.sidebar .sidebar-logo {
    display: flex;
    align-items: center;
    gap: 10px;
}

.sidebar.collapsed .sidebar-logo {
    justify-content: center;
}

.desktop-toggler {
    border: none;
    background: transparent;
    color: #0d6efd;
    outline: none;
    box-shadow: none;
    transition: color 0.2s ease;
}

.desktop-toggler:hover,
.desktop-toggler:focus,
.desktop-toggler:active {
    border: none;
    background: transparent !important;
    color: #0b5ed7;
    outline: none;
    box-shadow: none;
}


/* footer style  */
/* Desktop footer */
.footer-desktop {
    position: fixed;
    bottom: 0;
    left: 250px;
    /* sidebar expanded width */
    width: calc(100% - 250px);
    height: 50px;
    transition: all 0.3s ease;
    z-index: 1000;
}

/* When sidebar collapses */
.sidebar.collapsed~.flex-grow-1 .footer-desktop {
    left: 80px;
    /* collapsed width */
    width: calc(100% - 80px);
}

/* Footer text style */
.footer-desktop small {
    color: #6c757d;
    font-size: 13px;
}

/* Mobile footer nav */
.footer-mobile {
    z-index: 1;
    background: #0b5ed7;
}

.footer-mobile .footer-link {
    text-decoration: none;
    color: #ffffffff;
    transition: color 0.2s ease;
}

.footer-mobile .footer-link.active,
.footer-mobile .footer-link:hover {
    color: #ffc107;
}

.footer-mobile i {
    display: block;
    line-height: 1;
}


#body-content {
    overflow-y: auto;
    height: calc(100vh - 80px);
}

.accordion {
    background: #0097a7;
    cursor: pointer;
    margin: 0 auto;
    border-radius: 3px;
    box-shadow: 0 10px 15px -20px rgba(0, 0, 0, 0.3), 0 30px 45px -30px rgba(0, 0, 0, 0.3), 0 80px 55px -30px rgba(0, 0, 0, 0.1);
}
</style>