<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Bootstrap Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom JS -->
<script src="../assets/js/admin.js"></script>
<script src="../assets/js/main.js"></script>
<script src="../assets/js/ajax.js"></script>
<script src="../assets/js/validation.js"></script>
<script src="../assets/js/chart.js"></script>
<script src="../assets/js/notification.js"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
    const sidebar = document.getElementById("desktopSidebar");
    const toggleBtn = document.getElementById("sidebarToggle");

    // Load saved state
    if (localStorage.getItem("sidebarCollapsed") === "true") {
        sidebar.classList.add("collapsed");
    }

    toggleBtn.addEventListener("click", () => {
        sidebar.classList.toggle("collapsed");
        localStorage.setItem("sidebarCollapsed", sidebar.classList.contains("collapsed"));
    });
});
</script>

<!-- Footer active script -->
<script>
document.addEventListener("DOMContentLoaded", () => {
    const links = document.querySelectorAll(".footer-mobile .footer-link");
    const currentPage = window.location.pathname.split("/").pop();

    links.forEach(link => {
        if (link.getAttribute("href").includes(currentPage)) {
            link.classList.add("active");
        }
    });
});
</script>

<script>
let watchId = null;
let forceInterval = null;
let trackingStarted = false;

let lastGoodPosition = null;
let stableCount = 0;

const REQUIRED_ACCURACY = 30; // meters
const REQUIRED_STABLE_READS = 2;
const MAX_ACCEPTABLE_ACCURACY = 80;

// Shared GPS options (IMPORTANT)
const GPS_OPTIONS = {
    enableHighAccuracy: true,
    timeout: 60000, // allow cold start
    maximumAge: 15000 // allow cached fallback
};

/* ================= RESUME IF PRESENT ================= */

function resumeTrackingIfPresent() {

    fetch("ajax/check_attendance.php", {
            credentials: "same-origin"
        })
        .then(res => res.text())
        .then(resp => {
            if (resp === "PRESENT") {
                console.log("Attendance found. Starting GPS...");
                startTracking();
            }
        })
        .catch(err => console.error("Attendance check failed", err));
}

document.addEventListener("DOMContentLoaded", resumeTrackingIfPresent);

/* ================= INIT ATTENDANCE ================= */

function initAttendanceTracking() {

    if (!navigator.geolocation) {
        console.log("GPS not supported");
        return;
    }

    navigator.geolocation.getCurrentPosition(
        pos => {

            fetch("auto_attendance.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded"
                    },
                    credentials: "same-origin",
                    body: new URLSearchParams({
                        latitude: pos.coords.latitude,
                        longitude: pos.coords.longitude
                    })
                })
                .then(res => res.text())
                .then(resp => {
                    console.log("ATTENDANCE:", resp);

                    if (
                        resp.includes("START_GPS_MARKETING") ||
                        resp.includes("START_GPS_NON_MARKETING")
                    ) {
                        startTracking();
                    }
                });

        },
        handleGeoError,
        GPS_OPTIONS
    );
}

/* ================= START TRACKING ================= */

function startTracking() {

    if (trackingStarted) return;
    trackingStarted = true;

    console.log("GPS tracking started");

    watchId = navigator.geolocation.watchPosition(
        handlePosition,
        handleGeoError,
        GPS_OPTIONS
    );

    forceInterval = setInterval(() => {
        navigator.geolocation.getCurrentPosition(
            handlePosition,
            handleGeoError,
            GPS_OPTIONS
        );
    }, 60000);
}

/* ================= HANDLE POSITION ================= */

function handlePosition(pos) {

    if (!pos || !pos.coords) return;

    const acc = pos.coords.accuracy;
    console.log("GPS accuracy:", acc);

    // Reject very poor GPS
    if (acc > MAX_ACCEPTABLE_ACCURACY) {
        stableCount = 0;
        return;
    }

    // Prefer high accuracy but don't stall forever
    if (acc <= REQUIRED_ACCURACY) {
        stableCount++;
    } else {
        stableCount = 0;

        // fallback if nothing sent yet
        if (!lastGoodPosition) {
            lastGoodPosition = pos;
            sendLocation(pos);
        }
        return;
    }

    if (stableCount < REQUIRED_STABLE_READS) return;

    lastGoodPosition = pos;
    stableCount = 0;

    sendLocation(pos);
}

/* ================= SEND LOCATION ================= */

function sendLocation(pos) {

    fetch("location_track.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded"
        },
        credentials: "same-origin",
        body: new URLSearchParams({
            latitude: pos.coords.latitude,
            longitude: pos.coords.longitude,
            accuracy: pos.coords.accuracy,
            speed: pos.coords.speed || 0
        })
    });
}

/* ================= ERROR HANDLER ================= */

function handleGeoError(err) {

    if (!err) return;

    switch (err.code) {
        case err.PERMISSION_DENIED:
            console.error("GPS permission denied");
            break;
        case err.POSITION_UNAVAILABLE:
            console.warn("GPS unavailable, retrying...");
            break;
        case err.TIMEOUT:
            console.warn("GPS timeout – waiting for better fix...");
            break;
        default:
            console.error("GPS error", err);
    }
}
</script>


</body>

</html>