<?php
// Detect current page name (without extension)
$currentPage = basename($_SERVER['PHP_SELF'], '.php');

// Define sidebar & navbar menu items
$menuItems = [
    'index'      => ['title' => 'Dashboard', 'icon' => 'fa-home'],
    'attendance' => ['title' => 'Attendance', 'icon' => 'fa-fingerprint'],
    'leaves'     => ['title' => 'Leaves', 'icon' => 'fa-calendar'],
    'payroll'    => ['title' => 'Payroll', 'icon' => 'fa-money-bill'],
    'reports'    => ['title' => 'Reports', 'icon' => 'fa-chart-line'],
    'profile'    => ['title' => 'Profile', 'icon' => 'fa-user']
];

// Get readable page title safely
$pageTitle = $menuItems[$currentPage]['title'] ?? ucfirst($currentPage);

// Detect section (admin or employee)
$scriptPath = $_SERVER['SCRIPT_NAME'];
if (strpos($scriptPath, '/employee/') !== false) {
    $dashboardUrl = './index.php';
} elseif (strpos($scriptPath, '/admin/') !== false) {
    $dashboardUrl = './dashboard.php';
} else {
    $dashboardUrl = './index.php';
}
?>

<!-- Top Navbar -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm px-3 sticky-top">
    <button class="btn btn-outline-dark d-lg-none me-2" type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasSidebar" aria-controls="offcanvasSidebar">
        <i class="fa fa-bars"></i>
    </button>

    <!-- Collapsible Sidebar Toggle for Desktop -->
    <button class="btn btn-outline-dark d-none d-lg-inline-block me-3 desktop-toggler" id="sidebarToggle">
        <i class="fa fa-bars"></i>
    </button>

    <!-- Page Title -->
    <a class="navbar-brand fw-bold" href="<?= htmlspecialchars($dashboardUrl) ?>">
        <?= htmlspecialchars($pageTitle); ?>
    </a>

    <div class="ms-auto d-flex align-items-center">
        <!-- Notifications -->
        <div class="dropdown me-3 position-relative d-none">
            <a href="#" class="text-dark" id="notificationDropdown" data-bs-toggle="dropdown">
                <i class="fa-regular fa-bell fs-5"></i>
                <span class="badge bg-danger rounded-pill position-absolute top-0 start-100 translate-middle">3</span>
            </a>
            <ul class="dropdown-menu dropdown-menu-end">
                <li><a class="dropdown-item" href="#">Leave Request</a></li>
                <li><a class="dropdown-item" href="#">Payroll Processed</a></li>
                <li><a class="dropdown-item" href="#">Attendance Report</a></li>
            </ul>
        </div>

        <!-- User Dropdown -->
        <div class="dropdown">
            <a href="#" class="d-flex align-items-center text-dark text-decoration-none" data-bs-toggle="dropdown">
                <img src="../assets/img/employees/default.jpeg" alt="Profile" width="32" height="32"
                    class="rounded-circle me-2">
                <strong>Employee</strong>
            </a>
            <ul class="dropdown-menu dropdown-menu-end text-small">
                <li><a class="dropdown-item" href="./profile.php">Profile</a></li>
                <li><a class="dropdown-item" href="../logout.php">Logout</a></li>
            </ul>
        </div>
    </div>
</nav>