<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <!-- Dashboard Quick Links -->
            <div class="row g-3 mb-4">
                <div class="col-6 col-md-4">
                    <a href="./attendance.php" class="text-decoration-none">
                        <div class="card border-0 shadow-sm text-center p-3">
                            <i class="fa fa-fingerprint fa-2x text-primary mb-2"></i>
                            <h6>Today's Attendance</h6>
                            <p class="text-muted small mb-0 d-none">Present</p>
                        </div>
                    </a>
                </div>
                <div class="col-6 col-md-4">
                    <a href="./tasks.php" class="text-decoration-none">
                        <div class="card border-0 shadow-sm text-center p-3">
                            <i class="fa fa-calendar-check fa-2x text-success mb-2"></i>
                            <h6>Tasks</h6>
                            <p class="text-muted small mb-0 d-none">2 Pending</p>
                        </div>
                    </a>
                </div>
                <div class="col-6 col-md-4">
                    <a href="./payroll.php" class="text-decoration-none">
                        <div class="card border-0 shadow-sm text-center p-3">
                            <i class="fa fa-wallet fa-2x text-warning mb-2"></i>
                            <h6>Payroll</h6>
                            <p class="text-muted small mb-0 d-none">Next Pay: 1-5 Nov</p>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Attendance and Notifications Section -->
            <div class="row g-4">
                <!-- Today's Work List -->
                <?php
                $uid = $_SESSION['uid'];
                $today = date('Y-m-d');

                // 1. GET TODAY'S PENDING TASKS
                $todayTasks = mysqli_query($con,"
                    SELECT w.*,u.uname
                    FROM work_list w
                    JOIN work_schedule s ON w.wl_ws_id = s.ws_id
                    JOIN users u ON s.ws_for = u.uid
                    WHERE w.wl_status != 1 
                    AND DATE(s.ws_date) = '$today'
                    AND s.ws_for = '$uid'
                ");

                // 2. IF no today task, fallback ALL pending
                if(mysqli_num_rows($todayTasks) == 0){
                    $todayTasks = mysqli_query($con,"
                        SELECT w.*,u.uname
                        FROM work_list w
                        JOIN work_schedule s ON w.wl_ws_id = s.ws_id
                        JOIN users u ON s.ws_for = u.uid
                        WHERE w.wl_status != 1
                        AND s.ws_for = '$uid'
                    ");
                }
                ?>

                <div class="col-lg-8">
                    <div class="card shadow-sm border-0">
                        <div
                            class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Today's/Pending Work List</h6>
                            <a href="./tasks.php" class="text-white small text-decoration-none">View All</a>
                        </div>

                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0 align-middle">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Task</th>
                                            <th>Status</th>
                                            <th class="d-none">Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                        if(mysqli_num_rows($todayTasks) == 0){
                                            echo "<tr><td colspan='5' class='text-center text-muted'>No tasks found</td></tr>";
                                        }

                                        while($row = mysqli_fetch_assoc($todayTasks)){

                                            // Normalize the raw status value into a meaningful label:
                                            $raw = isset($row['wl_status']) ? trim((string)$row['wl_status']) : '';
                                            if ($raw === '1' || strcasecmp($raw, 'completed') === 0) {
                                                $statusLabel = 'Completed';
                                                $badgeClass  = 'success';
                                            } else {
                                                // treat anything else (including '', '0', null, 'pending', etc.) as Pending
                                                $statusLabel = 'Pending';
                                                $badgeClass  = 'danger';
                                            }

                                            // Prepare selected attributes for the select
                                            $selPending   = ($statusLabel === 'Pending') ? "selected" : "";
                                            $selCompleted = ($statusLabel === 'Completed') ? "selected" : "";

                                            echo "
                                            <tr>
                                                <td>".htmlspecialchars($row['wl_title'])."</td>

                                                <td><span class='badge bg-{$badgeClass}'>".$statusLabel."</span></td>

                                                <td class='d-none'>
                                                    <select class='form-select form-select-sm task-status' data-id='".intval($row['wl_id'])."'>
                                                        <option value='Pending' {$selPending}>Pending</option>
                                                        <option value='Completed' {$selCompleted}>Completed</option>
                                                    </select>
                                                </td>
                                            </tr>";
                                        }
                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Notifications -->
                <?php
                function timeAgo($time){
                    $timestamp = strtotime($time);
                    $diff = time() - $timestamp;

                    if($diff < 60) return "Just now";
                    $mins = round($diff/60);
                    if($mins < 60) return $mins . " min ago";
                    $hours = round($diff/3600);
                    if($hours < 24) return $hours . " hr ago";
                    $days = round($diff/86400);
                    if($days == 1) return "Yesterday";
                    if($days < 7) return $days . " days ago";
                    return date("d M Y", $timestamp);
                }
                ?>

                <div class="col-lg-4">
                    <div class="card shadow-sm border-0">
                        <div
                            class="card-header bg-secondary text-white d-flex justify-content-between align-items-center">
                            <h6 class="mb-0">Recent Notifications</h6>
                            <a href="./notice.php" class="text-white small text-decoration-none">View All</a>
                        </div>

                        <div class="card-body">
                            <?php
                            $admin_ref = mysqli_query($con, "SELECT admin_ref FROM users WHERE uid = '$uid' ");
                            $admin_row = mysqli_fetch_assoc($admin_ref);
                            $admin_ref = $admin_row["admin_ref"];

                            // fetch org id
                            $orgRow = mysqli_fetch_assoc(mysqli_query($con,
                                "SELECT uid FROM users WHERE uref='$admin_ref'" 
                            ));
                            $org_id = $orgRow['uid'];

                            $sql = "(SELECT id,title AS msg,created_at AS time,'Notice' AS type FROM notices WHERE notice_for='$org_id' AND (department_id='all' OR department_id IN (SELECT utypeorg FROM users WHERE uid='$uid')))UNION(SELECT leave_id AS id,CONCAT('Leave ', status) AS msg,applied_on AS time,'Leave' AS type FROM leaves WHERE user_id='$uid')UNION(SELECT id,CONCAT('Resignation ', status) AS msg,updated_at AS time,'Resignation' AS type FROM resignations WHERE user_id='$uid') ORDER BY time DESC LIMIT 5 ";

                            $notify = mysqli_query($con, $sql);

                            if (mysqli_num_rows($notify) > 0) {
                                while ($n = mysqli_fetch_assoc($notify)) {

                                    $icon = match($n['type']) {
                                        'Notice'      => 'fa-bullhorn text-primary',
                                        'Leave'       => 'fa-calendar-check text-success',
                                        'Resignation' => 'fa-flag text-danger',
                                        default       => 'fa-info-circle text-secondary'
                                    };

                                    echo "
                                    <div class='mb-3 border-bottom pb-2'>
                                        <p class='mb-1 text-dark'>
                                            <i class='fa $icon me-1'></i> {$n['msg']}
                                        </p>
                                        <small class='text-muted'>
                                            <i class='fa fa-clock me-1'></i>".timeAgo($n['time'])."
                                        </small>
                                    </div>";
                                }
                            } else {
                                echo "<p class='text-muted mb-0'>No notifications yet.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>