<?php 
include('./include/header.php'); 
if ($_SESSION['utype'] !== 'employee') {
    header("Location: ../login.php");
    exit;
}
$uid = $_SESSION['uid'];
?>

<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4">
            <div class="d-flex justify-content-between mb-3">
                <h5 class="fw-bold"><i class="fa fa-plane-departure text-primary me-2"></i>My Leaves</h5>
                <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#applyLeaveModal">
                    <i class="fa fa-plus me-1"></i>Apply for Leave
                </button>
            </div>
            <!--<?php
            // $bal = $con->query("SELECT * FROM leave_balance WHERE user_id=$uid")->fetch_assoc();
            ?>
            <div class="alert alert-info d-flex justify-content-between align-items-center">
                <div>
                    <strong>Casual Leave:</strong> <?= $bal['casual_leave'] ?> days |
                    <strong>Sick Leave:</strong> <?= $bal['sick_leave'] ?> days
                </div>
            </div>-->

            <div class="card shadow-sm border-0">
                <div class="card-body table-responsive">
                    <table class="table table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Leave Type</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Reason</th>
                                <th>Status</th>
                                <th>Remarks</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $sql = $con->prepare("SELECT * FROM leaves WHERE user_id=? ORDER BY applied_on DESC");
                            $sql->bind_param("i", $uid);
                            $sql->execute();
                            $res = $sql->get_result();
                            $i=1;
                            while($row = $res->fetch_assoc()){
                                $badge = match($row['status']){
                                    'Approved' => 'success',
                                    'Rejected' => 'danger',
                                    default => 'warning'
                                };
                                echo "<tr>
                                    <td>{$i}</td>
                                    <td>{$row['leave_type']}</td>
                                    <td>{$row['start_date']}</td>
                                    <td>{$row['end_date']}</td>
                                    <td>{$row['reason']}</td>
                                    <td><span class='badge bg-{$badge}'>{$row['status']}</span></td>
                                    <td>{$row['remarks']}</td>
                                </tr>";
                                $i++;
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Apply Leave Modal -->
        <div class="modal fade" id="applyLeaveModal" tabindex="-1">
            <div class="modal-dialog">
                <form class="modal-content" method="POST" action="leave_action.php">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title"><i class="fa fa-plus-circle me-2"></i>Apply for Leave</h5>
                        <button class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <label>Leave Type</label>
                        <select class="form-select mb-2" name="leave_type" required>
                            <option value="">Select</option>
                            <option value="Casual Leave">Casual Leave</option>
                            <option value="Sick Leave">Sick Leave</option>
                            <option value="Paid Leave">Paid Leave</option>
                        </select>

                        <label>From Date</label>
                        <input type="date" class="form-control mb-2" name="start_date" required>

                        <label>To Date</label>
                        <input type="date" class="form-control mb-2" name="end_date" required>

                        <label>Reason</label>
                        <textarea class="form-control" name="reason" required></textarea>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn-success" type="submit" name="apply_leave">Submit</button>
                    </div>
                </form>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<?php include('./include/js.php'); ?>