<?php
session_start();
include "../config/db.php";
include "../config/constants.php";

if (!isset($_SESSION['uid'])) exit;

$emp_id = $_SESSION['uid'];
$org_id = $_SESSION['uref'];

$lat   = $_POST['latitude'] ?? null;
$lng   = $_POST['longitude'] ?? null;
$acc   = $_POST['accuracy'] ?? null;
$speed = $_POST['speed'] ?? 0;

if (!$lat || !$lng) exit;
if ($acc === null || $acc > 100) exit;

/* GET DESIGNATION */
$userQ = mysqli_query($con,"
    SELECT d.d_name
    FROM users u
    JOIN designation d ON d.d_id = u.utypeorg
    WHERE u.uid = '$emp_id'
");
$user = mysqli_fetch_assoc($userQ);

$marketingRoles = [
    'Marketing Manager',
    'Marketing Executive',
    'marketing'
];

$isMarketing = false;
foreach ($marketingRoles as $role) {
    if (stripos($user['d_name'], $role) !== false) {
        $isMarketing = true;
        break;
    }
}

/* DISTANCE FUNCTION */
function distance($lat1, $lon1, $lat2, $lon2) {
    $earth = 6371000;
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat/2)**2 +
         cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
         sin($dLon/2)**2;
    return $earth * (2 * asin(sqrt($a)));
}

/* NON-MARKETING → CHECK LAST LOCATION */
if (!$isMarketing) {

    $lastQ = mysqli_query($con,"
        SELECT latitude, longitude
        FROM emp_location_track
        WHERE emp_id = '$emp_id'
        ORDER BY created_at DESC
        LIMIT 1
    ");

    if ($last = mysqli_fetch_assoc($lastQ)) {

        $dist = distance(
            $last['latitude'],
            $last['longitude'],
            $lat,
            $lng
        );

        // Ignore if movement ≤ 100 meters
        if ($dist <= 100) {
            exit;
        }
    }
}

/* INSERT LOCATION (Marketing OR shifted Non-Marketing) */
$stmt = $con->prepare("
    INSERT INTO emp_location_track
    (emp_id, org_id, latitude, longitude, accuracy, speed, created_at)
    VALUES (?, ?, ?, ?, ?, ?, NOW())
");

$stmt->bind_param(
    "iissdd",
    $emp_id,
    $org_id,
    $lat,
    $lng,
    $acc,
    $speed
);

$stmt->execute();