<?php
session_start();
include "../config/db.php";

if (!isset($_SESSION['uid']) || $_SESSION['utype'] !== 'employee') {
    http_response_code(403);
    echo "Unauthorized";
    exit;
}

$uid = (int)$_SESSION['uid'];
$token = $_POST['token'] ?? '';

if (empty($token)) {
    echo "Invalid QR token.";
    exit;
}

$today = date('Y-m-d');
$expected = hash('sha256', $today . ATTENDANCE_SECRET);

if (!hash_equals($expected, $token)) {
    echo "Invalid or expired QR code.";
    exit;
}

// check if already checked in
$chk = $con->prepare("SELECT * FROM attendance WHERE user_id=? AND date=? LIMIT 1");
$chk->bind_param("is", $uid, $today);
$chk->execute();
$res = $chk->get_result();
if ($res && $res->num_rows > 0) {
    echo "You have already checked in today.";
    exit;
}

// get working start from settings
$workStart = '09:00:00';
$q = $con->query("SELECT setting_key, setting_value FROM leave_settings WHERE setting_key='working_start_time'");
if ($q && $r = $q->fetch_assoc()) $workStart = $r['setting_value'];

$startTs = strtotime($workStart);
$nowTs = time();
$grace = $startTs + (15 * 60);

$status = ($nowTs <= $grace) ? 'Present' : 'Late';

// insert attendance
$stmt = $con->prepare("INSERT INTO attendance (user_id, date, check_in, status, created_at) VALUES (?, ?, NOW(), ?, NOW())");
$stmt->bind_param("iss", $uid, $today, $status);
if ($stmt->execute()) {
    echo "Attendance marked successfully: {$status}";
} else {
    echo "Failed to mark attendance. Try again.";
}