<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-4" id="body-content">
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h4 class="mb-3">All Notifications</h4>

                    <?php
                    $uid = $_SESSION['uid'];
                    $limit = 10; 
                    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
                    $start = ($page-1)*$limit;

                    $admin_ref = mysqli_query($con, "SELECT admin_ref FROM users WHERE uid = '$uid' ");
                    $admin_row = mysqli_fetch_assoc($admin_ref);
                    $admin_ref = $admin_row["admin_ref"];

                    // fetch org id
                    $orgRow = mysqli_fetch_assoc(mysqli_query($con,
                        "SELECT uid FROM users WHERE uref='$admin_ref'" 
                    ));
                    $org_id = $orgRow['uid'];

                    // MAIN QUERY
                    $sql = "(SELECT id,title AS msg,message,created_at AS time,'Notice' AS type 
                            FROM notices 
                            WHERE notice_for='$org_id' AND (department_id='all' 
                                OR department_id IN (SELECT utypeorg FROM users WHERE uid='$uid')))
                            UNION
                            (SELECT leave_id AS id,CONCAT('Leave ', status) AS msg,reason AS details,applied_on AS time,'Leave' AS type 
                            FROM leaves WHERE user_id='$uid')
                            UNION
                            (SELECT id,CONCAT('Resignation ', status) AS msg,reason AS details,updated_at AS time,'Resignation' AS type 
                            FROM resignations WHERE user_id='$uid')
                            ORDER BY time DESC LIMIT $start,$limit";

                    $notices = mysqli_query($con,$sql);
                    ?>

                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Message</th>
                                    <th>Type</th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php if(mysqli_num_rows($notices)>0){ 
                                    while($r=mysqli_fetch_assoc($notices)){
                                ?>
                                <tr>
                                    <td><?= $r['msg'] ?></td>
                                    <td><?= $r['type'] ?></td>
                                    <td><?= date("d M Y h:i A",strtotime($r['time'])) ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-primary viewNoticeBtn" data-id="<?= $r['id'] ?>"
                                            data-type="<?= $r['type'] ?>">
                                            View
                                        </button>
                                    </td>
                                </tr>
                                <?php }} else{ ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted">No notifications found.</td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>


                    <?php
                        // PAGINATION COUNT
                        $count_sql = "
                            SELECT COUNT(*) AS total FROM (
                                SELECT id 
                                FROM notices 
                                WHERE notice_for='$org_id' 
                                AND (
                                    department_id='all' 
                                    OR department_id IN (
                                        SELECT utypeorg FROM users WHERE uid='$uid'
                                    )
                                )

                                UNION ALL

                                SELECT leave_id AS id 
                                FROM leaves 
                                WHERE user_id='$uid'

                                UNION ALL

                                SELECT id 
                                FROM resignations 
                                WHERE user_id='$uid'
                            ) AS x
                        ";

                        $total = mysqli_fetch_assoc(mysqli_query($con,$count_sql))['total'];
                        $pages = ceil($total/$limit);
                        ?>

                    <!-- PAGINATION -->
                    <nav>
                        <ul class="pagination">
                            <?php for($i=1;$i<=$pages;$i++){ ?>
                            <li class="page-item <?=($i==$page?'active':'')?>">
                                <a class="page-link" href="?page=<?=$i?>"><?=$i?></a>
                            </li>
                            <?php } ?>
                        </ul>
                    </nav>


                    <!-- MODAL -->
                    <div class="modal fade" id="noticeModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header bg-primary text-white">
                                    <h5 class="modal-title">Notification</h5>
                                    <button type="button" class="btn-close btn-close-white"
                                        data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body" id="noticeContent">
                                    Loading...
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>
<script>
document.querySelectorAll('.viewNoticeBtn').forEach(btn => {
    btn.addEventListener('click', function() {
        let id = this.dataset.id;
        let type = this.dataset.type;

        fetch("ajax/getNotice.php?id=" + id + "&type=" + type)
            .then(res => res.text())
            .then(data => {
                document.getElementById("noticeContent").innerHTML = data;
                new bootstrap.Modal(document.getElementById('noticeModal')).show();
            });
    });
});
</script>
<?php include('./include/js.php'); ?>