<?php
include('./include/header.php');

$uid = $_SESSION['uid']; // Logged-in employee’s ID
?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>
        <div class="container-fluid p-4" id="body-content">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="fw-bold mb-0">
                    <i class="fa fa-money-bill-wave me-2 text-success"></i> My Payroll & Salary Details
                </h5>
            </div>

            <?php
            // Fetch salary details for this employee
            $sql = "SELECT * FROM employee_salary_assigned WHERE user_id = '$uid'";
            $result = $con->query($sql);

            if ($result->num_rows > 0) {
                $salary = $result->fetch_assoc();
                $basic = $salary['basic_salary'];
                $allowances = ($salary['hra'] ?? 0) + ($salary['da'] ?? 0) + ($salary['ta'] ?? 0) + ($salary['others'] ?? 0);
                $total = $basic + $allowances;

                $locationText = $salary['work_location'] === 'Office'
                    ? 'Office'
                    : "Other (" . $salary['latitude'] . ", " . $salary['longitude'] . ")";
            ?>

            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-bold mb-3 text-primary">Current Salary Structure</h6>
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="text-muted small mb-1">Basic Salary</label>
                            <h6 class="fw-bold">₹<?= number_format($basic, 2) ?></h6>
                        </div>
                        <div class="col-md-3">
                            <label class="text-muted small mb-1">Total Allowances</label>
                            <h6 class="fw-bold">₹<?= number_format($allowances, 2) ?></h6>
                        </div>
                        <div class="col-md-3">
                            <label class="text-muted small mb-1">Total Salary</label>
                            <h6 class="fw-bold text-success">₹<?= number_format($total, 2) ?></h6>
                        </div>
                        <div class="col-md-3">
                            <label class="text-muted small mb-1">Work Location</label>
                            <h6 class="fw-bold"><?= htmlspecialchars($locationText) ?></h6>
                        </div>
                    </div>

                    <hr class="my-3">

                    <div class="row g-3">
                        <div class="col-md-2"><strong>HRA:</strong> ₹<?= number_format($salary['hra'] ?? 0, 2) ?></div>
                        <div class="col-md-2"><strong>DA:</strong> ₹<?= number_format($salary['da'] ?? 0, 2) ?></div>
                        <div class="col-md-2"><strong>TA:</strong> ₹<?= number_format($salary['ta'] ?? 0, 2) ?></div>
                        <div class="col-md-2"><strong>Others:</strong> ₹<?= number_format($salary['others'] ?? 0, 2) ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php
            } else {
                echo "<div class='alert alert-warning'>No salary record assigned yet. Please contact your administrator.</div>";
            }
            ?>

            <?php
            if (!function_exists('getMonthName')) {
                function getMonthName($num) {
                    $months = [1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",
                        7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December"];
                    return $months[intval($num)] ?? "Unknown";
                }
            }
            /*  PROMOTION PAGINATION  */
            $promo_limit = 5;
            $promo_page = isset($_GET['promo_page']) ? max(1, (int)$_GET['promo_page']) : 1;
            $promo_offset = ($promo_page - 1) * $promo_limit;

            $totalPromoRow = $con->query("SELECT COUNT(*) AS total FROM employee_salary_history WHERE user_id='$uid'")->fetch_assoc();

            $totalPromo = $totalPromoRow['total'];
            $totalPromoPages = ceil($totalPromo / $promo_limit);

            $promoRes = $con->query("SELECT * FROM employee_salary_history WHERE user_id='$uid' 
                ORDER BY changed_at DESC 
                LIMIT $promo_limit OFFSET $promo_offset
            ");

            /* ================= SALARY PAGINATION ================= */
            $salary_limit = 5;
            $salary_page = isset($_GET['salary_page']) ? max(1, (int)$_GET['salary_page']) : 1;
            $salary_offset = ($salary_page - 1) * $salary_limit;

            $totalSalaryRow = $con->query("
                SELECT COUNT(*) AS total 
                FROM employee_salary 
                WHERE salary_for='$_SESSION[uid]'
            ")->fetch_assoc();

            $totalSalary = $totalSalaryRow['total'];
            $totalSalaryPages = ceil($totalSalary / $salary_limit);

            $salarySql = mysqli_query($con, "
                SELECT * FROM employee_salary 
                WHERE salary_for='$_SESSION[uid]' 
                ORDER BY emp_salary_id DESC 
                LIMIT $salary_limit OFFSET $salary_offset
            ");

            $salaryIndex = $salary_offset + 1;
            ?>

            <!-- ================= PROMOTION HISTORY ================= -->
            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <h6 class="fw-bold mb-3 text-success">
                        <i class="fa fa-history me-2"></i> Promotion & Increment History
                    </h6>

                    <div class="table-responsive">
                        <table class="table table-bordered table-sm align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Old Basic</th>
                                    <th>New Basic</th>
                                    <th>Old Total</th>
                                    <th>New Total</th>
                                    <th>Promotion Title</th>
                                    <th>Remark</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if ($promoRes->num_rows > 0) {
                                    $i = $promo_offset + 1;
                                    while ($r = $promoRes->fetch_assoc()) {
                                        echo "<tr>
                                            <td>{$i}</td>
                                            <td>₹" . number_format($r['old_basic'], 2) . "</td>
                                            <td>₹" . number_format($r['new_basic'], 2) . "</td>
                                            <td>₹" . number_format($r['old_total'], 2) . "</td>
                                            <td>₹" . number_format($r['new_total'], 2) . "</td>
                                            <td>" . htmlspecialchars($r['promotion_title']) . "</td>
                                            <td>" . htmlspecialchars($r['remark']) . "</td>
                                            <td>" . date('d M Y', strtotime($r['changed_at'])) . "</td>
                                        </tr>";
                                        $i++;
                                    }
                                } else {
                                    echo "<tr><td colspan='8' class='text-center text-muted'>No promotion history yet.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if ($totalPromoPages > 1) { ?>
                    <nav>
                        <ul class="pagination pagination-sm justify-content-end">
                            <?php for ($p = 1; $p <= $totalPromoPages; $p++) { ?>
                            <li class="page-item <?= ($p == $promo_page) ? 'active' : '' ?>">
                                <a class="page-link" href="?promo_page=<?= $p ?>&salary_page=<?= $salary_page ?>">
                                    <?= $p ?>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </nav>
                    <?php } ?>
                </div>
            </div>

            <!--  SALARY HISTORY  -->
            <div class="card shadow-sm p-3 mb-4 border-0">
                <h6 class="fw-bold mb-3 text-success">
                    <i class="fa fa-history me-2"></i> Salary History
                </h6>

                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Year / Month</th>
                                <th>Basic</th>
                                <th>Incentive</th>
                                <th>Other Incentive</th>
                                <th>Deductions</th>
                                <th>Total</th>
                                <th>Mode</th>
                                <th>Payment Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = mysqli_fetch_assoc($salarySql)) { ?>
                            <tr>
                                <td><?= $salaryIndex++; ?></td>
                                <td><?= $row["salary_year"]; ?> - <?= getMonthName($row["salary_month"]); ?></td>
                                <td><?= $row["salary_basic"]; ?></td>
                                <td><?= $row["salary_insentive"]; ?></td>
                                <td><?= $row["other_insentive_title"]." : ".$row["other_insentive_amount"]; ?></td>
                                <td><?= $row["deductions_title"]." : ".$row["deductions_amount"]; ?></td>
                                <td><?= $row["salary_total"]; ?></td>
                                <td><?= $row["salary_mode"]; ?></td>
                                <td><?= $row["salary_up_date"]; ?></td>
                                <td>
                                    <button class="btn btn-primary btn-sm print-btn"
                                        data-id="<?= $row["emp_salary_id"]; ?>">
                                        Print Slip
                                    </button>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

                <?php if ($totalSalaryPages > 1) { ?>
                <nav>
                    <ul class="pagination pagination-sm justify-content-end">
                        <?php for ($s = 1; $s <= $totalSalaryPages; $s++) { ?>
                        <li class="page-item <?= ($s == $salary_page) ? 'active' : '' ?>">
                            <a class="page-link" href="?salary_page=<?= $s ?>&promo_page=<?= $promo_page ?>">
                                <?= $s ?>
                            </a>
                        </li>
                        <?php } ?>
                    </ul>
                </nav>
                <?php } ?>
            </div>

        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>



<!--  SALARY PRINT MODAL  -->
<div class="modal fade" id="printModal" tabindex="-1" aria-labelledby="printModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content" id="printArea">
            <div class="modal-header">
                <h5 class="modal-title" id="printModalLabel">Salary Slip</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="printContent"
                data-empname="<?php echo htmlspecialchars($_SESSION['uname']); ?>">
                <div class="text-center text-muted my-4">Loading...</div>
            </div>
            <div class="modal-footer d-print-none">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><i class="fa fa-times"></i>
                    Close</button>
                <button type="button" class="btn btn-primary" id="printBtn"><i class="fa fa-print"></i> Print</button>
            </div>
        </div>
    </div>
</div>

<!-- SCRIPT ORDER -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/dataTables.bootstrap5.min.js"></script>
<script src="../assets/vendor/ckeditor.js"></script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    if ($.fn.DataTable && $('#salaryTable').length) {
        $('#salaryTable').DataTable({
            responsive: true,
            pageLength: 10
        });
    }

    const yearSelect = document.getElementById("year");
    if (yearSelect) {
        const currentYear = new Date().getFullYear();
        for (let y = currentYear; y >= currentYear - 10; y--) {
            const opt = document.createElement("option");
            opt.value = y;
            opt.textContent = y;
            yearSelect.appendChild(opt);
        }
    }

    // Handle Print Slip Button
    $(document).on('click', '.print-btn', function() {
        const salaryId = $(this).data('id');
        $('#printContent').html('<div class="text-center text-muted my-4">Loading...</div>');
        const modal = new bootstrap.Modal(document.getElementById('printModal'));
        modal.show();

        $.get('./ajax/get-salary-slip.php', {
            id: salaryId
        }, function(data) {
            $('#printContent').html(data);
        }).fail(function() {
            $('#printContent').html(
                '<p class="text-danger text-center">Unable to load slip.</p>');
        });
    });

    // Print Button Action  
    $('#printBtn').on('click', function() {
        const originalTitle = document.title;

        // Try to fetch employee name and month/year from slip content
        const employeeName = $('#printContent').data('empname');

        const slipTitleText = $('#printContent')
            .find('p:contains("Pay Slip for")')
            .first()
            .text()
            .replace('Pay Slip for', '')
            .trim();

        // Build print title
        const printTitle = `Pay Slip - ${employeeName} - ${slipTitleText}`;

        document.title = printTitle;

        const printContents = document.getElementById('printContent').innerHTML;
        const originalContents = document.body.innerHTML;

        document.body.innerHTML = printContents;
        window.print();

        // Restore page
        document.body.innerHTML = originalContents;
        document.title = originalTitle;
        location.reload();
    });

});
document.getElementById('cancelSalaryForm').addEventListener('click', function() {
    const collapseElement = document.getElementById('salaryForm');
    const bsCollapse = bootstrap.Collapse.getOrCreateInstance(collapseElement);
    bsCollapse.hide(); // Explicitly close the collapse
});
</script>

<script>
$(document).ready(function() {

    $('select[name="salary_month"], select[name="salary_year"]').on('change', function() {

        let month = $('select[name="salary_month"]').val();
        let year = $('select[name="salary_year"]').val();
        let user_id = <?= $_SESSION["uid"] ?>;

        if (month && year) {
            $.ajax({
                url: "ajax/get_salary_summary.php",
                type: "POST",
                data: {
                    month: month,
                    year: year,
                    user_id: user_id
                },
                success: function(res) {
                    $("#salarySummaryBox").show();
                    $("#summaryContent").html(res);
                }
            });
        }
    });

});
</script>


<style>
@media print {
    body * {
        visibility: hidden;
    }

    #printArea,
    #printArea * {
        visibility: visible;
    }

    #printArea {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
}
</style>


<?php include('./include/js.php'); ?>