<?php include('./include/header.php'); ?>
<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>
    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>
        <style>
        /* REPORT TABS */

        .report-tabs {
            display: flex;
            gap: 8px;
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .report-tabs li {
            display: inline-block;
        }

        .tab-btn {
            border: none;
            background: #f8f9fa;
            color: #555;
            padding: 5px 5px;
            border-radius: 5px;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            transition: all 0.25s ease;
            border: 1px solid transparent;
        }

        .tab-btn i {
            font-size: 15px;
            opacity: 0.8;
        }

        .tab-btn:hover {
            background: #eef2ff;
            color: #4338ca;
        }

        .tab-btn.active {
            background: #ffffff;
            color: #4338ca;
            border: 1px solid #e5e7eb;
            border-bottom: 2px solid #ffffff;
            box-shadow: 0 -2px 8px rgba(67, 56, 202, 0.08);
        }

        .tab-btn.active i {
            opacity: 1;
        }
        </style>

        <div class="container-fluid p-4" id="body-content">
            <h5 class="mb-3">📊 My Reports</h5>

            <!-- FILTER -->
            <form id="reportFilterForm" class="row align-items-end g-2 mb-3">
                <div class="col-md-3">
                    <label>From</label>
                    <input type="date" name="from" value="<?= $today ?>" class="form-control form-control-sm">
                </div>
                <div class="col-md-3">
                    <label>To</label>
                    <input type="date" name="to" value="<?= $today ?>" class="form-control form-control-sm">
                </div>
                <div class="col-md-6">
                    <!-- TABS -->
                    <ul class="nav nav-pills mb-3 mb-lg-0">
                        <li class="nav-item">
                            <button type="button" class="nav-link active tab-btn" data-type="attendance"
                                onclick="switchTab(this)">
                                Attendance
                            </button>
                        </li>
                        <li class="nav-item">
                            <button type="button" class="nav-link tab-btn" data-type="work" onclick="switchTab(this)">
                                Work Report
                            </button>
                        </li>
                        <li class="nav-item">
                            <button type="button" class="nav-link tab-btn" data-type="leave" onclick="switchTab(this)">
                                Leave Report
                            </button>
                        </li>
                    </ul>
                </div>
            </form>

            <!-- RESULT -->
            <div id="reportResult"></div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<script>
let currentReport = "attendance";

function loadReport(type) {
    currentReport = type;

    const params = new URLSearchParams(
        new FormData(document.getElementById("reportFilterForm"))
    );

    fetch(`ajax/${type}_report.php?` + params)
        .then(res => res.text())
        .then(html => {
            document.getElementById("reportResult").innerHTML = html;
        });
}

function switchTab(btn) {
    document.querySelectorAll(".tab-btn").forEach(b => b.classList.remove("active"));
    btn.classList.add("active");
    loadReport(btn.dataset.type);
}

// Auto load attendance
window.addEventListener("DOMContentLoaded", () => {
    loadReport("attendance");
});

// Reload on date change
document.getElementById("reportFilterForm")
    .addEventListener("change", () => loadReport(currentReport));
</script>
<?php include('./include/js.php'); ?>