<?php include('./include/header.php'); ?>

<div class="d-flex flex-column flex-lg-row">
    <?php include('./include/sidebar.php'); ?>

    <div class="flex-grow-1">
        <?php include('./include/topbar.php'); ?>

        <div class="container-fluid p-3" id="body-content">
            <div id="notification" style="position: absolute;padding: 5px;right: 0;z-index: 99;border-radius: 7px;">
            </div>

            <div class="card shadow-sm p-3 mb-4">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $schedules = [];
                        $pendingSchedules = [];

                        $sql = mysqli_query($con, "SELECT * FROM work_schedule WHERE ws_for = '$_SESSION[uid]' ORDER BY ws_date DESC");

                        while ($row = mysqli_fetch_assoc($sql)) {
                            $ws_id = $row['ws_id'];
                            $date = date('Y-m-d', strtotime($row['ws_date']));
                            $wl_sql = mysqli_query($con, "SELECT * FROM work_list WHERE wl_ws_id = '$ws_id'");

                            $hasPending = false;
                            while ($wl = mysqli_fetch_assoc($wl_sql)) {
                                if ($wl['wl_status'] != 1) {
                                    $hasPending = true;
                                    break;
                                }
                            }

                            if ($hasPending) {
                                $pendingSchedules[] = $row;
                            }

                            $schedules[$date][] = $row;
                        }

                        $dates = array_keys($schedules);
                        rsort($dates);
                        $dates = array_slice($dates, 0, 7);
                        ?>

                        <!-- Tabs -->
                        <ul class="nav nav-tabs" id="scheduleTabs" role="tablist">
                            <li class="nav-item">
                                <button class="nav-link active" id="pending-tab" data-bs-toggle="tab"
                                    data-bs-target="#pending" type="button" role="tab">
                                    Pending
                                </button>
                            </li>
                            <?php foreach ($dates as $date): 
                                $tabId = 'date_' . date("Ymd", strtotime($date));
                                $label = date("d M", strtotime($date));
                            ?>
                            <li class="nav-item">
                                <button class="nav-link" id="tab-<?= $tabId ?>" data-bs-toggle="tab"
                                    data-bs-target="#<?= $tabId ?>" type="button" role="tab">
                                    <?= $label ?>
                                </button>
                            </li>
                            <?php endforeach; ?>
                            <li class="nav-item">
                                <button class="nav-link" id="calendar-tab" data-bs-toggle="tab"
                                    data-bs-target="#calendar" type="button" role="tab">
                                    <i class="fa-solid fa-calendar-days"></i> Calendar
                                </button>
                            </li>
                        </ul>

                        <!-- Tab Content -->
                        <div class="tab-content mt-3" id="scheduleTabContent">
                            <!-- Pending Tab -->
                            <div class="tab-pane fade show active" id="pending" role="tabpanel">
                                <?php foreach ($pendingSchedules as $row) {
                                    include './ajax/work_schedule_card.php';
                                } ?>
                            </div>

                            <!-- Date Tabs -->
                            <?php foreach ($dates as $date): 
                                $tabId = 'date_' . date("Ymd", strtotime($date)); ?>
                            <div class="tab-pane fade" id="<?= $tabId ?>" role="tabpanel">
                                <h5 class="text-primary mt-3"><?= date("l, d M Y", strtotime($date)); ?></h5>
                                <?php 
                                if (!empty($schedules[$date])) {
                                    foreach ($schedules[$date] as $row) {
                                        include './ajax/work_schedule_card.php';
                                    }
                                } else {
                                    echo "<p>No schedules for this date.</p>";
                                }
                                ?>
                            </div>
                            <?php endforeach; ?>

                            <!-- Calendar Tab -->
                            <div class="tab-pane fade" id="calendar" role="tabpanel">
                                <input type="date" id="scheduleDatePicker" class="form-control w-25 mb-3">
                                <div id="dateScheduleContainer"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('./include/footer.php'); ?>
    </div>
</div>

<!-- Bootstrap Modal -->
<div class="modal fade" id="remarkModal" tabindex="-1" aria-labelledby="remarkModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Submit Remark</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><strong>Admin Remark:</strong></p>
                <p id="adminRemarkText" class="remark-box border p-2">Loading...</p>
                <div>
                    <label for="ws_workRemark" class="form-label">Work Remark:</label>
                    <p id="ws_workRemark" class="remark-box border p-2"></p>
                </div>
                <form id="remarkForm">
                    <div class="mb-3">
                        <label for="ws_workRemark2" class="form-label">Enter Remark:</label>
                        <textarea class="form-control" id="ws_workRemark2" rows="4" required></textarea>
                    </div>
                    <input type="hidden" id="remark_ws_id">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="submitRemarkBtn">Submit</button>
            </div>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
// Calendar load
$('#scheduleDatePicker').on('change', function() {
    var selectedDate = this.value;
    fetch('./ajax/fetch_schedule_by_date.php?date=' + selectedDate +
            '&work_id=<?= $_SESSION["uid"] ?>')
        .then(res => res.text())
        .then(data => $('#dateScheduleContainer').html(data));
});

// Accordion toggle
$(document).on('click', '.accordion .heading', function() {
    $(this).toggleClass('active').next().slideToggle();
    $('.contents').not($(this).next()).slideUp(300);
    $(this).siblings().removeClass('active');
});

// Toggle status AJAX
$(document).on('change', '.toggleStatus', function() {
    var wl_id = $(this).data('id');
    var status = $(this).is(':checked') ? '1' : '';

    $.post('./ajax/update_work_status.php', {
        wl_id,
        status
    }, function(response) {
        if (response.trim() === 'success') {
            showNotification('Successfully updated status.', '#28a745');
            setTimeout(() => location.reload(), 2000);
        } else {
            showNotification('Failed to update status.', '#dc3545');
        }
    }).fail(() => showNotification('AJAX request failed.', '#dc3545'));
});

// Open remark modal
$(document).on('click', '.openRemarkModal', function() {
    var ws_id = $(this).data('id');
    $('#remark_ws_id').val(ws_id);
    $('#adminRemarkText').text('Loading...');
    $('#ws_workRemark').text('');

    // Fetch remarks
    fetch('ajax/get_admin_remark.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: 'ws_id=' + encodeURIComponent(ws_id)
        })
        .then(res => res.json())
        .then(data => {
            $('#adminRemarkText').text(data.adminRemark || 'No remark found.');
            $('#ws_workRemark').html((data.workRemark || '').replace(/\n/g, '<br>'));
        })
        .catch(() => $('#adminRemarkText').text('Failed to load remark.'));

    new bootstrap.Modal(document.getElementById('remarkModal')).show();
});

// Submit remark
$('#submitRemarkBtn').on('click', function() {
    const ws_id = $('#remark_ws_id').val();
    const workRemark2 = $('#ws_workRemark2').val();

    fetch('./ajax/submit_work_remark.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: `ws_id=${encodeURIComponent(ws_id)}&ws_workRemark=${encodeURIComponent(workRemark2)}`
        })
        .then(res => res.text())
        .then(resp => {
            if (resp.trim() === 'success') {
                showNotification('Remark updated successfully.', '#28a745');
                bootstrap.Modal.getInstance(document.getElementById('remarkModal')).hide();
            } else {
                showNotification('Failed to update remark.', '#dc3545');
            }
        })
        .catch(() => showNotification('Failed to submit remark. Try again.', '#dc3545'));
});


// Notification
function showNotification(message, color = '#28a745') {
    const notification = $('#notification');
    notification.text(message).css('background', color).fadeIn();
    setTimeout(() => notification.fadeOut(), 2000);
}
</script>

<?php include('./include/js.php'); ?>