<!-- Firebase SDK -->
<script src="https://www.gstatic.com/firebasejs/9.23.0/firebase-app-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.23.0/firebase-messaging-compat.js"></script>

<script>
// Initialize Firebase
const firebaseConfig = {
    apiKey: "YOUR_API_KEY",
    authDomain: "YOUR_PROJECT_ID.firebaseapp.com",
    projectId: "YOUR_PROJECT_ID",
    storageBucket: "YOUR_PROJECT_ID.appspot.com",
    messagingSenderId: "YOUR_SENDER_ID",
    appId: "YOUR_APP_ID"
};
firebase.initializeApp(firebaseConfig);

const messaging = firebase.messaging();

// Request permission and get token
messaging.requestPermission()
    .then(() => messaging.getToken())
    .then(token => {
        console.log('FCM Token:', token);
        // Send token to backend via AJAX
        $.post('/ajax/notifications.php', {
            action: 'save_token',
            token: token
        });
    })
    .catch(err => {
        console.error('Permission or token error:', err);
    });

// Handle foreground message
messaging.onMessage(payload => {
    console.log('Message received: ', payload);
    const notificationTitle = payload.notification.title;
    const notificationOptions = {
        body: payload.notification.body,
        icon: '/assets/img/icons/notification.png'
    };
    new Notification(notificationTitle, notificationOptions);
});
</script>