<?php
session_start();
include("config/db.php");
include("config/functions.php");

define("SPECIAL_ADMIN_LOGIN", "admin");
define("SPECIAL_ADMIN_PASSWORD", "Admin@123");
define("SPECIAL_ADMIN_UID", 91);

// Auto-login from cookie
if (isset($_COOKIE['remember_token'])) {
    $token = clean($_COOKIE['remember_token']);
    $sql = $con->prepare("SELECT * FROM users WHERE remember_token = ?");
    $sql->bind_param("s", $token);
    $sql->execute();
    $user = $sql->get_result()->fetch_assoc();

    if ($user) {
        $_SESSION["uid"] = $user['uid'];
        $_SESSION["utype"] = $user['utype'];
        $_SESSION["uref"] = $user['uref'];
        $_SESSION["uname"] = $user['uname'];
        $_SESSION["uphone"] = $user['uphone'];
        redirect($user['utype'] == 'employee' ? 'employee/' : 'admin/');
    }
}

$error = "";

if (isset($_POST['login_button'])) {

    $login_id = clean($_POST['uphone']);
    $password = clean($_POST['password']);

    /* =====================================
       🔐 SPECIAL ADMIN LOGIN (UID = 203)
    ===================================== */
    if ($login_id === SPECIAL_ADMIN_LOGIN && $password === SPECIAL_ADMIN_PASSWORD) {

        $uid = SPECIAL_ADMIN_UID;

        $stmt = $con->prepare("SELECT * FROM users WHERE uid = ?");
        $stmt->bind_param("i", $uid);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();

        if (!$user) {
            $error = "Admin account not found.";
        } else {

            $_SESSION["uid"]    = $user['uid'];
            $_SESSION["utype"]  = $user['utype'];
            $_SESSION["uref"]   = $user['uref'];
            $_SESSION["uname"]  = $user['uname'];
            $_SESSION["uphone"] = $user['uphone'];

            logAction($user['uid'], "Special Admin Login", "Forced UID 203 login");

            redirect("admin/");
        }

    }

    /* =====================================
       🔐 NORMAL USER LOGIN
    ===================================== */
    else {

        $user = getUserByPhone($login_id);

        if ($user) {

            // Employee status check
            if ($user['utype'] === 'employee' && $user['emp_status'] != 1) {
                $error = "Your account is deactivated. Please contact admin.";
                logAction($user['uid'], "Login Failed", "Inactive employee account");
            }
            elseif ($user['utype'] === 'employee' && $user['udisplay'] === "disable") {
                $error = "Your account is disabled by admin.";
                logAction($user['uid'], "Login Failed", "User disabled");
            }
            else {

                // Password verification
                if (verifyPassword($password, $user['upass'])) {

                    $_SESSION["uid"]    = $user['uid'];
                    $_SESSION["utype"]  = $user['utype'];
                    $_SESSION["uref"]   = $user['uref'];
                    $_SESSION["uname"]  = $user['uname'];
                    $_SESSION["uphone"] = $user['uphone'];

                    // Remember me
                    if (!empty($_POST['remember'])) {
                        $token = bin2hex(random_bytes(16));
                        setcookie("remember_token", $token, time() + (86400 * 30), "/", "", false, true);

                        $stmt = $con->prepare("UPDATE users SET remember_token=? WHERE uid=?");
                        $stmt->bind_param("si", $token, $user['uid']);
                        $stmt->execute();
                    }

                    logAction($user['uid'], "Login", "Successful login");

                    // Redirect
                    if ($user['utype'] === 'master_admin') {
                        redirect("user1/");
                    }
                    elseif ($user['utype'] === 'basic_lvl_admin') {
                        redirect("admin/");
                    }
                    else {
                        redirect("employee/");
                    }

                } else {
                    $error = "Incorrect password.";
                    logAction($user['uid'], "Login Failed", "Invalid password");
                }
            }

        } else {
            $error = "No account found with this number.";
        }
    }
}

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | HRM Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
    body {
        background: linear-gradient(135deg, #007bff 0%, #00bcd4 100%);
        height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .login-card {
        width: 100%;
        max-width: 420px;
        background: #fff;
        border-radius: 15px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        padding: 2rem;
    }

    .btn-primary {
        background-color: #007bff;
        border: none;
    }

    .btn-primary:hover {
        background-color: #0069d9;
    }

    .toggle-password {
        cursor: pointer;
    }

    .login-header {
        text-align: center;
        margin-bottom: 1.5rem;
    }

    .login-header h4 {
        color: #007bff;
        font-weight: 600;
    }

    .footer-text {
        text-align: center;
        font-size: 0.9rem;
        color: #6c757d;
        margin-top: 1rem;
    }
    </style>
</head>

<body>
    <div class="login-card">
        <div class="login-header">
            <h4>HRM Login</h4>
            <p class="text-muted small">Sign in to continue</p>
        </div>

        <?php if ($error): ?>
        <div class="alert alert-danger small text-center py-2"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST" autocomplete="off" id="loginForm">
            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="uphone" name="uphone" placeholder="Mobile Number" required>
                <label for="uphone"><i class="fa fa-phone me-2"></i>Mobile Number</label>
            </div>

            <div class="form-floating mb-3 position-relative">
                <input type="password" class="form-control" id="password" name="password" placeholder="Password"
                    required>
                <label for="password"><i class="fa fa-lock me-2"></i>Password</label>
                <span class="position-absolute top-50 end-0 translate-middle-y pe-3 toggle-password">
                    <i class="fa fa-eye text-muted" id="togglePassword"></i>
                </span>
            </div>

            <div class="form-check mb-3">
                <input type="checkbox" class="form-check-input" id="remember" name="remember">
                <label for="remember" class="form-check-label small">Remember me</label>
                <a href="forgot-password.php" class="float-end small text-decoration-none text-primary">Forgot
                    Password?</a>
            </div>

            <button type="submit" class="btn btn-primary w-100 py-2" name="login_button">Login</button>
        </form>

        <div class="footer-text">© <?= date("Y") ?> HRM | All Rights Reserved</div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script>
    $('#togglePassword').on('click', function() {
        const input = $('#password');
        const type = input.attr('type') === 'password' ? 'text' : 'password';
        input.attr('type', type);
        $(this).toggleClass('fa-eye fa-eye-slash');
    });
    </script>
</body>

</html>