<?php
session_start();
include("config/db.php"); 

// If the user was logged in and had a remember_token stored — remove it
if (isset($_SESSION['uid'])) {
    $uid = $_SESSION['uid'];

    // Remove remember token from DB
    $stmt = $con->prepare("UPDATE users SET remember_token = NULL WHERE uid = ?");
    $stmt->bind_param("i", $uid);
    $stmt->execute();
}

// Destroy all session data
$_SESSION = [];
session_unset();
session_destroy();

// Remove the remember cookie if exists
if (isset($_COOKIE['remember_token'])) {
    setcookie("remember_token", "", time() - 3600, "/");
}

// Redirect to login page
header("Location: login.php?logout=success");
exit;
?>