<?php
include("config/functions.php");

$token = $_GET['token'] ?? '';
$message = "";
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = clean($_POST['token']);
    $newpass = clean($_POST['newpass']);
    $confpass = clean($_POST['confpass']);

    if ($newpass !== $confpass) {
        $message = "Passwords do not match!";
    } else {
        $stmt = $con->prepare("SELECT * FROM users WHERE reset_token=? AND reset_expiry > NOW()");
        $stmt->bind_param("s", $token);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();

        if ($user) {
            $stmt2 = $con->prepare("UPDATE users SET upass=?, reset_token=NULL, reset_expiry=NULL WHERE uid=?");
            $stmt2->bind_param("si", $newpass, $user['uid']);
            $stmt2->execute();

            $message = "Password successfully reset. You can now login.";
            $success = true;
        } else {
            $message = "Invalid or expired reset link.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password | HRM Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
    body {
        background: linear-gradient(135deg, #007bff 0%, #00bcd4 100%);
        height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .login-card {
        width: 100%;
        max-width: 420px;
        background: #fff;
        border-radius: 15px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        padding: 2rem;
    }

    .btn-primary {
        background-color: #007bff;
        border: none;
    }

    .btn-primary:hover {
        background-color: #0069d9;
    }
    </style>
</head>

<body>
    <div class="login-card">
        <h4 class="text-center mb-3 text-primary">Reset Password</h4>

        <?php if ($message): ?>
        <div class="alert alert-<?= $success ? 'success' : 'danger' ?> text-center small py-2">
            <?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <?php if (!$success): ?>
        <form method="POST">
            <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">

            <div class="form-floating mb-3">
                <input type="password" class="form-control" id="newpass" name="newpass" placeholder="New Password"
                    required>
                <label for="newpass"><i class="fa fa-lock me-2"></i>New Password</label>
            </div>

            <div class="form-floating mb-3">
                <input type="password" class="form-control" id="confpass" name="confpass" placeholder="Confirm Password"
                    required>
                <label for="confpass"><i class="fa fa-lock me-2"></i>Confirm Password</label>
            </div>

            <button type="submit" class="btn btn-primary w-100 py-2">Reset Password</button>
        </form>
        <?php else: ?>
        <div class="text-center mt-3">
            <a href="login.php" class="btn btn-success btn-sm">Back to Login</a>
        </div>
        <?php endif; ?>
    </div>
</body>

</html>