<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("include/meta.php");?>
    <?php include("include/css.php");?>
</head>

<body>
    <?php include("include/preloader.php");?>
    <?php include("include/header.php");?>


    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5 position-relative overflow-hidden">
        <video class="bg-video" autoplay muted loop playsinline>
            <source src="./images/banner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="video-overlay"></div>
        <div class="container py-5 position-relative z-1">
            <h1 class="display-3 text-white mb-3 animated slideInDown">About Us</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
                    <li class="breadcrumb-item text-white active" aria-current="page">About</li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->

    <!-- About Start -->
    <div class="container-fluid overflow-hidden px-lg-0 py-5">
        <div class="container about px-lg-0">
            <div class="row g-0 mx-lg-0">
                <div class="col-lg-7 about-text wow fadeIn" data-wow-delay="0.5s">
                    <div class="p-lg-5 pe-lg-0">
                        <div class="section-title text-start">
                            <h1 class="display-5 mb-4">Welcome to <span style="color:#0184bc;"> AYUSH LPO</span></h1>
                        </div>
                        <p class="mb-4 pb-2" align="justify"> We, at Ayush LPO, an unit of ATFCPL led consortium, have
                            been dedicated to
                            provide services to
                            its clients in various sectors including financial as well as legal aspects which is
                            primarily
                            required for smooth running of the Small and Medium Enterprises as well as other business
                            entity
                            including corporate houses.
                            <br> <br>
                            Our company is managed by professionals like Chartered Accountants, Cost Accountants,
                            Company
                            Secretaries, IT Professionals and Lawyers. It is Professionally Committed to provide
                            dedicated
                            service in a cost effective manner without diluting the quality. Our aim is to establish a
                            personal and long term relationship with each client with a view to tailoring our services
                            to
                            their individual needs. We pride ourselves on our ability to deal in a professional manner
                            and
                            also on a qualitative and timely basis with any assignments we undertake. the glass of some
                            proven parameters we call FRAME.
                        </p>
                        <a href="about.php" class="btn btn-primary py-3 px-5">Read More</a>
                    </div>
                </div>

                <div class="col-lg-5 py-5 ps-lg-0 wow fadeIn" data-wow-delay="0.7s">
                    <div class="notice">
                        <div class="section-title text-center">
                            <h2 class="display-5 text-white pt-2">Latest Notices</h2>
                        </div>
                        <div class="owl-carousel notice-carousel">
                            <?php
                                $notice_sql = "SELECT * FROM blog WHERE bby = '$x' AND bcat = '26' ORDER BY bid DESC ";
                                $notice_run = mysqli_query($con, $notice_sql);
                                while ( $notice_rows = mysqli_fetch_assoc($notice_run) ) {
                                    $bPath = substr($notice_rows['bimage'], 3);
                                    $bPath = "./login/".$bPath;
                            ?>
                            <div class="notice-item p-4 text-center">
                                <img src="<?php echo $bPath;?>" alt="">
                                <a href="notice_total.php?notice_title=<?php echo $notice_rows['bid']; ?>">
                                    <h5 class="mb-0 mt-3 text-white">
                                        <?php echo mb_strimwidth($notice_rows['btitle'], 0, 40, '...'); ?>
                                    </h5>
                                </a>
                            </div>
                            <?php }?>
                        </div>
                        <div class="index-notice-ancor">
                            <a href="notice.php" title="All Notice"><i class="fa fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->

    <!-- Client Logos Start -->
    <div class="container-xxl bg-light py-5 wow fadeInUp" data-wow-delay="0.1s">
        <div class="container">
            <div class="section-title text-center">
                <h1 class="display-5 mb-5">Our Clients</h1>
            </div>
            <div class="owl-carousel client-logo-carousel">
                <div class="client-logo-item text-center">
                    <img src="images/placements/agri.jpg" class="img-fluid" alt="Client">
                </div>
                <div class="client-logo-item text-center">
                    <img src="images/placements/BANK.jpg" class="img-fluid" alt="Client">
                </div>
                <div class="client-logo-item text-center">
                    <img src="images/placements/CONSTR.jpg" class="img-fluid" alt="Client">
                </div>
                <div class="client-logo-item text-center">
                    <img src="images/placements/dairy.jpg" class="img-fluid" alt="Client">
                </div>
                <div class="client-logo-item text-center">
                    <img src="images/placements/MANU.jpg" class="img-fluid" alt="Client">
                </div>
                <div class="client-logo-item text-center">
                    <img src="images/placements/FMCG.jpg" class="img-fluid" alt="Client">
                </div>
            </div>
        </div>
    </div>
    <!-- Client Logos End -->


    <?php include("include/footer.php");?>
    <?php include("include/js.php");?>
</body>

</html>