<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("include/meta.php");?>
    <?php include("include/css.php");?>
</head>
<style>
.gallery-img {
    height: 250px;
    object-fit: cover;
}
</style>

<body>
    <?php include("include/preloader.php");?>
    <?php include("include/header.php");?>


    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5 position-relative overflow-hidden">
        <video class="bg-video" autoplay muted loop playsinline>
            <source src="./images/banner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="video-overlay"></div>
        <div class="container py-5 position-relative z-1">
            <h1 class="display-3 text-white mb-3 animated slideInDown">Image Gallery</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
                    <li class="breadcrumb-item text-white active" aria-current="page">Image Gallery</li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- Projects Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-primary mb-3">Our Image Gallery</h1>
            </div>
            <div class="row g-4 portfolio-container justify-content-center">
                <?php
                $news_sql = "SELECT * FROM gallery WHERE tby = '$x' ORDER BY id DESC";
                $news_run = mysqli_query($con, $news_sql);
                while ($news_rows = mysqli_fetch_assoc($news_run)) {
                    $filePath = "login/" . substr($news_rows['image'], 3);
                    $fileExtension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));

                    // Display only image files
                    if (in_array($fileExtension, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                ?>
                <div class="col-lg-4 col-md-6 portfolio-item wow fadeInUp" data-wow-delay="0.1s">
                    <div class="rounded overflow-hidden position-relative">
                        <img class="img-fluid w-100 gallery-img" src="<?php echo $filePath; ?>" alt="Gallery Image">
                        <div class="portfolio-overlay d-flex align-items-center justify-content-center">
                            <a class="btn btn-square btn-outline-light mx-1" href="<?php echo $filePath; ?>"
                                data-lightbox="gallery">
                                <i class="fa fa-eye"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <?php 
                    } // end image type check
                } ?>
            </div>
        </div>
    </div>
    <!-- Projects End -->


    <?php include("include/footer.php");?>
    <?php include("include/js.php");?>
</body>

</html>