<?php
    session_start();
    include "../../db.php";
    date_default_timezone_set('Asia/Kolkata');
    $currentTime = date('M j, Y g:i a');

    if ( !isset($_SESSION['uid']) && !isset($_SESSION['uref']) && !isset($_SESSION['utype']) )
        header("Location: logout.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Admin Panel</title>

    <link href="css/all.min.css" rel="stylesheet" type="text/css">
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/alltable.css" rel="stylesheet">
    <link rel="stylesheet" href="vendor/croppie/croppie.css" />
    <link href="css/style.css" rel="stylesheet">

    <style>
        #uploadimageModal .modal-dialog{
            max-width: 100% !important;
        }
    </style>
</head>
<body id="page-top" class="mt-55">

<div class="overlay"></div>

    <div id="wrapper">

        <div id="content-wrapper" class="d-flex flex-column">

            <div id="content">

                <?php include "includes/topbar.php"; ?>

                <div class="container-fluid px-0">

                    <div class="card shadow mb-4">
                        <div class="card-body">

                        
                            <h1 class="h3 mb-2 text-gray-800 text-center">Alumni Members</h1>
                            <p class="h5 mb-2 text-gray-800 text-center">   
                            </p>
                            <hr>

                                  
                                    <form class="user" method="post" enctype="multipart/form-data">
                                        <h4 class="mb-2 badge badge-secondary" data-toggle="collapse" data-target="#target" style="cursor:pointer;">Add New Member</h4>
                                        <p class="small"> <i class="fas fa-hand-point-up"></i> Tap Here to add New Member </p>
                                        <div class="collapse" id="target">
                                          
                                            <div class="form-group row">
                                                <div class="col-sm-12 mb-1 mb-sm-0">
                                                    <input type="text" class="form-control mb-2" id="name" placeholder="Enter Name" name="name" required>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-sm-12 mb-1 mb-sm-0">
                                                    <input type="text" class="form-control mb-2" id="design" placeholder="Enter Designation" name="design" required>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-sm-12 mb-1 mb-sm-0">
                                                    <input type="text" class="form-control mb-2" id="email" placeholder="Enter Email Id" name="email">
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-sm-12 mb-1 mb-sm-0">
                                                    <input type="text" class="form-control mb-2" id="ph" placeholder="Enter Phone No." name="ph">
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <div class="col-sm-12 mb-1 mb-sm-0">
                                                    <div class="custom-file mb-2">
                                                        <input type="file" class="custom-file-input" name="sliderlgimage" id="file" accept="image/*" required>
                                                        <label class="custom-file-label" for="file">Select Wallpaper Image *  (Image size- 800*320/1600*640)</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- <button type="submit" class="btn btn-primary btn-user m-2" name="new_slider">
                                                <i class="fas fa-user-plus"></i> Add New Slider
                                            </button> -->
                                            <a href="#target" data-toggle="collapse" class="btn btn-warning btn-user m-2"> <i class="fas fa-ban"></i> Cancel </a>
                                        </div>
                                    </form>
                                   

                            <hr>

                            <div class="row m-0">
                                <h4 class="mb-3 badge badge-secondary">Alumni</h4>

                                <div class="col-md-12 p-0">
                                    <div class="table-responsive">
                                        <table class="table table-hover table-bordered table-sm" id="thisismytable">
                                            <thead>
                                                <tr>
                                                    <th>No.</th>
                                                    <th>Title</th>
                                                    <th>Image</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                    $sql = "SELECT * FROM alumni WHERE a_by = '$_SESSION[uid]' ORDER BY a_sl ASC";
                                                    $run = mysqli_query($con, $sql);

                                                    $c = 1;
                                                    while ( $rows = mysqli_fetch_assoc($run) ) {
                                                                                                               
                                                       echo "
                                                        <tr>
                                                            <td>
                                                                <span class='badge badge-info badge-pill'>$c</span>
                                                            </td>
                                                            <td>
                                                           $rows[a_name] <br>
                                                           $rows[a_designation] <br>
                                                           $rows[a_email] <br>
                                                           $rows[a_ph] 

                                                            </td>
                                                            <td>
                                                                <img src='$rows[a_img]' height='50' data-toggle='modal' data-target='#show-img' class='showModal'>
                                                            </td>
                                                        ";
                                                        ?>
                                                            <td class='text-center align-middle'>
                                                                <!-- <a href='alumni.php?edit_id=$rows[sid]&sref=$rows[sref]&imgpath=$rows[slgimage]' class='m-2 btn btn-success btn-sm rounded-circle' title='Click to Edit'> <i class='fas fa-pencil-alt'></i> </a> -->

                                                                <a href='alumni.php?del_id=<?php echo $rows["a_sl"]; ?>&imgpath=<?php echo $rows["a_img"]; ?>' class='delete m-2 btn btn-danger btn-sm rounded-circle' title='Click to Delete'> <i class='fas fa-trash'></i> </a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        $c++;
                                                    }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>

            <?php include "includes/footer.php"; ?>

        </div>

    </div>




    <div class="modal fade" id="show-img" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <img src="" alt="sliderImage" id="image_modal" class="w-100">
                    <p class="small mt-3 mb-2" id="dimension"> <span class="font-weight-bold"> Name </span> : </p>
                    <p class="small mb-2" id="dimension"> <span class="font-weight-bold"> Dimension </span> : </p>
                    <p class="small mb-2" id="dimension"> <span class="font-weight-bold"> Size </span> : </p>
                </div>
                <div class="modal-footer">
                    <button type="close" class="btn btn-secondary" data-dismiss="modal"> Close </button>
                </div>
            </div>
        </div>
    </div>



    <div id="uploadimageModal" class="modal" role="dialog">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

                <div class="modal-header">
                    <h4 class="modal-title">Upload & Crop Image</h4>
                </div>

                <div class="modal-body">
                    <div class="row mx-0">
                        <div class="col-md-12 text-center">
                            <div id="image_demo" style="margin-top:10px;height:40%;width:1px;"></div>
                            <p class="small">scroll through mouse to zoom in or out</p>
                        </div>
                        <div class="col-md-12 text-center">
                            <button class="btn btn-success crop_image" id="cropppp">Crop & Upload Image</button>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
                </div>

            </div>
        </div>
    </div>




    <script>
        function checkFileDetails() {
            var fi = document.getElementById('file');
            if (fi.files.length > 0) {
                for (var i = 0; i <= fi.files.length - 1; i++) {
                    var fileName, fileExtension, fileSize, fileType, dateModified;
                    fileName = fi.files.item(i).name;
                    fileExtension = fileName.replace(/^.*\./, '');
                    if (fileExtension == 'png' || fileExtension == 'jpg' || fileExtension == 'jpeg') {
                        readImageFile(fi.files.item(i));
                    }
                }
                function readImageFile(file) {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        var img = new Image();
                        img.src = e.target.result;
                        img.onload = function () {
                            var imgWidth = this.width;
                            var imgHeight = this.height;

                            if ( imgWidth == 1000 && imgHeight == 700 || imgWidth == 400 && imgHeight == 280 ) {
                                var imgCheck = "<i class='fas fa-check-circle text-success'></i>";
                            } else {
                                var imgCheck = "<i class='fas fa-times-circle text-danger'></i>";
                            }
                            document.getElementById('fileInfo').innerHTML =
                                document.getElementById('fileInfo').innerHTML + '<br> ' +
                                'Name: <b>' + file.name + '</b> <br>' +
                                'Size: <b>' + Math.round((file.size / 1024)) + '</b> KB <br>' +
                                'Dimension: <b>' + imgWidth + '</b> x <b>' + imgHeight + '</b> ' + imgCheck + ' <br>';
                        }
                    };
                    reader.readAsDataURL(file);
                }
            }
        }
    </script>




    <script src="js/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <script src="js/sweetalert2.min.js"></script>
    <script src="js/jquery.dataTables.min.js"></script>
    <script src="js/dataTables.bootstrap4.min.js"></script>
    <script src="js/datatables.mark.min.js"></script>
    <script src="vendor/croppie/croppie.js"></script>
    <script src="js/jquery-ui-custom.min.js"></script>
    <script src="js/custom.js"></script>

    
    <script>
        $(document).ready(function(){
            $('#thisismytable').DataTable();
            $('#show-img').on('show.bs.modal', function (e) {
                var src = $(e.relatedTarget).attr('src');
                $(this).find('.modal-body > img').attr('src', src);
            });$image_crop = $('#image_demo').croppie({
                enableExif: true,
                viewport: {
                    width: 1000,
                    height: 700,
                    type: 'square' //circle
                },
                boundary: {
                    width: 1005,
                    height: 705,
                }
            });$('#file').on('change', function () {
                var reader = new FileReader();
                reader.onload = function (event) {
                    $image_crop.croppie('bind', {
                        url: event.target.result
                    }).then(function () {
                        console.log('jQuery bind complete');
                    });
                }
                reader.readAsDataURL(this.files[0]);
                $('#uploadimageModal').modal('show');
            });$('.crop_image').click(function (event) {
                $('#cropppp').html('uploading <i class="fas fa-spinner fa-pulse"></i>');
                
                var name = $('#name').val();
                var design = $('#design').val();
                var email = $('#email').val();
                var ph = $('#ph').val();

                $image_crop.croppie('result', {
                    type: 'canvas',
                    size: 'viewport'
                }).then(function (response) {
                    $.ajax({
                        url: "alumni.php",
                        type: "POST",
                        data: {
                            "image": response,
                           
                            name: name,
                            design: design,
                            email: email,
                            ph: ph
                        },
                        success: function (data) {
                            $('#uploadimageModal').modal('hide');
                            $('#uploaded_image').html(data);
                        }
                    });
                })
            });
        });

        // var $sortableCat = $("#catsList");

        // $sortableCat.sortable({
        //     stop: function ( event, ui ) {
        //         var parameters = $sortableCat.sortable( "toArray" );
        //         $.post("categories_position.php",{value:parameters},function(result){
        //             $(document).ready(function() {
        //                 const Toast = Swal.mixin({
        //                     toast: true,
        //                     position: 'bottom',
        //                     showConfirmButton: false,
        //                     timer: 2000
        //                 });
        //                 Toast.fire({
        //                     type: 'success',
        //                     title: result
        //                 });
        //             });
        //         });
        //     }
        // });

        var $sortable = $("#thisismytable > tbody");

        $sortable.sortable({
            stop: function ( event, ui ) {
                var parameters = $sortable.sortable( "toArray" );
                $.post("slider_position.php",{value:parameters},function(result){
                    console.log("Position Complete");
                });
            }
        });
    </script>

</body>
</html>



<?php
    if ( isset($_GET["del_id"]) ) {

        unlink($_GET["imgpath"]);

        $del_sql = "DELETE FROM alumni WHERE a_sl = '$_GET[del_id]'";

        if ( mysqli_query($con, $del_sql) ) {
            ?>
            <script>window.location = "alumni.php";</script>
            <?php
        } else {
            ?>
            <script>
                alert('OOPS !!!!');
                setTimeout(() => {
                    window.location = 'alumni.php';
                }, 500);
            </script>
          
            <?php
        }
    }


    if(isset($_POST["image"]))
    {
        $data = $_POST["image"];
       
        $name = $_POST["name"];
        $design = $_POST["design"];
        $email = $_POST["email"];
        $ph = $_POST["ph"];
        $sref = rand()."_".time();

        $image_array_1 = explode(";", $data);

        $image_array_2 = explode(",", $image_array_1[1]);

        $data = base64_decode($image_array_2[1]);

        $imageName = '../upload/alumni/'.rand() . '.png';

        file_put_contents($imageName, $data);
        function compress($source, $destination, $quality) {
            $info = getimagesize($source);

            if ($info['mime'] == 'image/jpeg') 
                $image = imagecreatefromjpeg($source);

            elseif ($info['mime'] == 'image/gif') 
                $image = imagecreatefromgif($source);

            elseif ($info['mime'] == 'image/png') 
                $image = imagecreatefrompng($source);

            imagejpeg($image, $destination, $quality);
            return $destination;
        }
        $destination_img = '../upload/alumni/'.rand() . '.png';
        $d = compress($imageName, $destination_img, 40);
        unlink($imageName);

        $new_ins_sql = "INSERT INTO alumni ( a_name, a_designation, a_by, a_email, a_ph, a_img) VALUES ( '$name', '$design', '$_SESSION[uid]', '$email', '$ph', '$destination_img ')";

        // echo "<pre>";print_r($new_ins_sql);exit();
        
        
         mysqli_query($con, $new_ins_sql);
        
   

    }
?>