<?php
    include "../dbconfig/dbconfig.php";

    function Redirect_To($NewLocation){
        header("Location:".$NewLocation);
        exit;	
    }
    function Password_Encryption($Password) {
        $BlowFish_Hash_Format = "$2y$10$"; // 2y to Tells PHP to use Blowfish with a "cost" of 10 
        $Salt_Length = 22; // Blowfish salts should be 22-characters or greater	
        $Salt = Generate_Salt($Salt_Length);
        $Formating_Blowfish_With_Salt = $BlowFish_Hash_Format.$Salt;
        $Hash = crypt($Password, $Formating_Blowfish_With_Salt);
        return $Hash;
    }

    function Generate_Salt($length) {
        // Not 100% unique, not 100% random, but good enough for a salt
        // MD5 Algorithm returns 32 characters
        $Unique_Random_String = md5(uniqid(mt_rand(), true));
        // Valid characters for a salt are [a to z - A to Z 0 to 9 . / ]
        $Base64_String = base64_encode($Unique_Random_String);
        // But not '+' which is valid in base64 encoding so we are replacing it with '.'

        $Modified_Base64_String = str_replace('+', '.', $Base64_String);
        //Using Substr function we Truncate string to the correct length
        $Salt = substr($Modified_Base64_String, 0, $length);

        return $Salt;
    }

    function Password_Check($Password, $Existing_Hash) {
        // existing hash contains format and salt  at start that we made in our password encyption function
        $Hash = crypt($Password, $Existing_Hash);
        if ($Hash === $Existing_Hash) {
            return true;
        } else {
            return false;
        }
    }

    // filesize functions
    function filesize_formatted($path)
    {
        $size = filesize($path);
        $units = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
        $power = $size > 0 ? floor(log($size, 1024)) : 0;
        return number_format($size / pow(1024, $power), 2, '.', ',') . ' ' . $units[$power];
    }

    // image compress function
    function compress_image($source_url, $destination_url, $quality) {
        $info = getimagesize($source_url);
        if ($info['mime'] == 'image/jpeg') $image = imagecreatefromjpeg($source_url);
        elseif ($info['mime'] == 'image/jpg') $image = imagecreatefromjpeg($source_url);
        elseif ($info['mime'] == 'image/gif') $image = imagecreatefromgif($source_url);
        elseif ($info['mime'] == 'image/png') {
            $image = imagecreatefrompng($source_url);
        }

        imagejpeg($image, $destination_url, $quality);

        return $destination_url;
    }

    // random number generate function
    function genRan( $valLength ) {
        $result = '';
        $moduleLength = 40;   // we use sha1, so module is 40 chars
        $steps = round(($valLength/$moduleLength) + 0.5);
    
        for( $i=0; $i<$steps; $i++ ) {
          $result .= sha1( uniqid() . md5( rand() . uniqid() ) );
        }
    
        return substr( $result, 0, $valLength );
    }

    // indian currency format
    function moneyFormatIndia($num) {
        $explrestunits = "" ;
        if(strlen($num)>3) {
            $lastthree = substr($num, strlen($num)-3, strlen($num));
            $restunits = substr($num, 0, strlen($num)-3); // extracts the last three digits
            $restunits = (strlen($restunits)%2 == 1)?"0".$restunits:$restunits; // explodes the remaining digits in 2's formats, adds a zero in the beginning to maintain the 2's grouping.
            $expunit = str_split($restunits, 2);
            for($i=0; $i<sizeof($expunit); $i++) {
                // creates each of the 2's group and adds a comma to the end
                if($i==0) {
                    $explrestunits .= (int)$expunit[$i].","; // if is first value , convert into integer
                } else {
                    $explrestunits .= $expunit[$i].",";
                }
            }
            $thecash = $explrestunits.$lastthree;
        } else {
            $thecash = $num;
        }
        return $thecash; // writes the final format where $currency is the currency symbol.
    }

    // redirect to product details page
    function reProDet( $protitle, $proid, $proreference, $proseller ) {

        $redirectTo = "
        product.php?torzoProName=$protitle&torzoProId=$proid&torzoProRef=$proreference&torzoProSeller=$proseller
        ";

        return $redirectTo;
    }

    // rating show
    function ratingCount( $val ) {
        if ( $val == '' || $val == NULL ) {
            $showRatings = "<i class='fas fa-times-circle text-danger' title='Ratings'></i>";
        }
        if ( $val >= 3.1 ) {
            $showRatings = "<span class='badge badge-success' title='Ratings' style='font-size: 15px;'> $val </span>";
        }
        elseif( $val >= 1.5 && $val <= 3.0 ) {
            $showRatings = "<span class='badge badge-warning' title='Ratings' style='font-size: 15px;'> $val </span>";
        }
        elseif( $val >= 0.1 && $val <= 1.4 ) {
            $showRatings = "<span class='badge badge-danger' title='Ratings' style='font-size: 15px;'> $val </span>";
        }

        return $showRatings;
    }

    

?>
