<?php
    date_default_timezone_set('Asia/Kolkata');

    function formatTimeString($timeStamp) {
        // $str_time = date("Y-m-d H:i:sP", $timeStamp);
        $time = strtotime($timeStamp);
        $d = new DateTime($timeStamp);

        $weekDays = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
        $months = ['Jan', 'Feb', 'Mar', 'Apr', ' May', 'Jun', 'Jul', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'];

        if ($time > strtotime('-2 minutes')) {
            return 'Just now';
        }
        elseif($time > strtotime('-59 minutes')) {
            $min_diff = floor((strtotime('now') - $time) / 60);
            return $min_diff.' min'.(($min_diff != 1) ? "s" : "").' ago';
        }
        elseif($time > strtotime('-23 hours')) {
            $hour_diff = floor((strtotime('now') - $time) / (60 * 60));
            return $hour_diff.' hour'.(($hour_diff != 1) ? "s" : "").' ago';
        }
        elseif($time > strtotime('today')) {
            return $d -> format('g:i a');
        }
        elseif($time > strtotime('yesterday')) {
            return 'Yesterday at '.$d -> format('g:i a');
        }
        elseif($time > strtotime('this week')) {
            return $weekDays[$d -> format('N') - 1].' at '.$d -> format('g:i a');
        } else {
            return $d -> format('j').' '.$months[$d -> format('n') - 1].(($d -> format('Y') != date("Y")) ? $d -> format(' Y') : "").' at '.$d -> format('g:i a');
        }
    }
?>