<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("include/meta.php");?>
    <?php include("include/css.php");?>
</head>

<body>
    <?php include("include/preloader.php");?>
    <?php include("include/header.php");?>


    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5 position-relative overflow-hidden">
        <video class="bg-video" autoplay muted loop playsinline>
            <source src="./images/banner.mp4" type="video/mp4">
            Your browser does not support the video.
        </video>
        <div class="video-overlay"></div>
        <div class="container py-5 position-relative z-1">
            <h1 class="display-3 text-white mb-3 animated slideInDown">Services</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
                    <li class="breadcrumb-item text-white active" aria-current="page">Services</li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- Service Start -->
    <?php
        $cat_run = mysqli_query($con, "SELECT cname, cid FROM category where catby=$x ORDER BY cpositon ASC limit 1");
        while ( $cat_rows = mysqli_fetch_assoc($cat_run) ) {
    ?>
    <div class="container-xxl py-5">
        <div class="container">
            <div class="section-title text-center">
                <h1 class="display-5 mb-5">Our <span style="color:#0184bc;"> Services</span></h1>
            </div>
            <div class="row g-4 justify-content-center">
                <?php
                    $service_sql = "SELECT * FROM blog WHERE bcat = '$cat_rows[cid]' ORDER BY bid ASC";
                    $service_run = mysqli_query($con, $service_sql);
                    while ( $service_rows = mysqli_fetch_assoc($service_run) ) {
                    $servicePath = substr($service_rows['bimage'], 3);
                    $servicePath = "login/".$servicePath;
                    $serviceTitle = mb_strimwidth($service_rows['btitle'], 0, 80, "...");
                ?>
                <div class="col-md-6 col-lg-4 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="service-item">
                        <div class="overflow-hidden">
                            <img class="img-fluid" src="<?php echo $servicePath;?>" alt="">
                        </div>
                        <div class="p-4 text-center">
                            <h4 class="mb-3"><?php echo $serviceTitle?></h4>
                            <p>
                                <?php
                                $fullBlog = $service_rows["blog"];

                                // Use regex to extract the first <p> block
                                if (preg_match('/<p>(.*?)<\/p>/is', $fullBlog, $matches)) {
                                    $firstParagraph = strip_tags($matches[1]); 

                                    // Limit to 200 characters
                                    $shortText = mb_strimwidth($firstParagraph, 0, 70, '...');
                                    echo $shortText;
                                } else {
                                    // Fallback if no <p> found
                                    echo mb_strimwidth(strip_tags($fullBlog), 0, 70, '...');
                                }
                                ?>
                            </p>
                            <a class="fw-medium"
                                href="article.php?id=<?php echo $service_rows["bid"].$service_rows["btag"];?>/"
                                title='<?php echo $service_rows["btitle"]?>'>Read More<i
                                    class="fa fa-arrow-right ms-2"></i></a>
                        </div>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
    <?php }?>
    <!-- Service End -->


    <?php include("include/footer.php");?>
    <?php include("include/js.php");?>
</body>

</html>