<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("include/meta.php");?>
    <?php include("include/css.php");?>
</head>
<style>
.team-item {
    transition: transform 0.3s ease;
    box-shadow: rgba(0, 0, 0, 0.19) 0px 10px 20px, rgba(0, 0, 0, 0.23) 0px 6px 6px;
    border-radius: 7px;
}

.team-item:hover {
    transform: translateY(-5px);
}

.avatar-lg {
    width: 80px;
    height: 80px;
}
</style>

<body>
    <?php include("include/preloader.php");?>
    <?php include("include/header.php");?>


    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5 position-relative overflow-hidden">
        <video class="bg-video" autoplay muted loop playsinline>
            <source src="./images/banner.mp4" type="video/mp4">
            Your browser does not support the video.
        </video>
        <div class="video-overlay"></div>
        <div class="container py-5 position-relative z-1">
            <h1 class="display-3 text-white mb-3 animated slideInDown">Our Team</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
                    <li class="breadcrumb-item text-white active" aria-current="page">Team</li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- Team Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-primary mb-3">Our Expert Team</h1>
                <p class="lead">Meet our seasoned professionals with decades of combined experience</p>
            </div>

            <div class="row g-5 justify-content-center">
                <!-- Member 1 -->
                <div class="col-lg-6 col-md-10 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="team-item bg-white rounded-4 p-4">
                        <div class="d-flex align-items-center gap-4 mb-4">
                            <div class="flex-shrink-0">
                                <div
                                    class="avatar-lg bg-primary text-white rounded-3 d-flex align-items-center justify-content-center">
                                    <span class="fs-3">SB</span>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h3 class="mb-1">Santanu Bhattacharjee</h3>
                                <p class="text-muted mb-0">Chartered Accountant</p>
                            </div>
                        </div>
                        <div class="team-content">
                            <p class="text-secondary mb-4">Experienced Chartered Accountant with 20+ years specializing
                                in:</p>
                            <ul class="list-unstyled d-grid gap-2">
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    Financial Management & Audit
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    Tax Advisory & Strategic Planning
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    Corporate Transformation & Risk Management
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    Financial Reporting & Compliance
                                </li>
                            </ul>
                            <p align="justify">
                                Experienced in delivering strategic financial insights, ensuring compliance, and
                                providing management consultancy. Proven track record in leading financial
                                transformation, serving as director across firms and fintechs, and driving turnaround
                                initiatives. Expertise spans financial reporting, tax advisory, audit, financial
                                analysis, risk management, budgeting, forecasting, and operational optimization.</p>
                        </div>
                    </div>
                </div>

                <!-- Member 2 -->
                <div class="col-lg-6 col-md-10 wow fadeInUp" data-wow-delay="0.2s">
                    <div class="team-item bg-white rounded-4 p-4">
                        <div class="d-flex align-items-center gap-4 mb-4">
                            <div class="flex-shrink-0">
                                <div
                                    class="avatar-lg bg-primary text-white rounded-3 d-flex align-items-center justify-content-center">
                                    <span class="fs-3">CJ</span>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h3 class="mb-1">C.P Jena</h3>
                                <p class="text-muted mb-0">Company Secretary</p>
                            </div>
                        </div>
                        <div class="team-content">
                            <p class="text-secondary mb-4">Company Secretary with 20+ expertise in:</p>
                            <ul class="list-unstyled d-grid gap-2">
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    Corporate Governance & Compliance
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    M&A and NCLT Litigation
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    IPO Listings & Startup Funding
                                </li>
                                <li class="d-flex align-items-center gap-2">
                                    <i class="fas fa-check-circle text-success"></i>
                                    Regulatory & Statutory Compliance
                                </li>
                            </ul>
                            <p align="justify">Seasoned professional with deep expertise in Company Law, regulatory
                                compliance, and corporate governance. Extensive experience handling NCLT litigation,
                                startup funding, mergers & acquisitions, company listings (BSE/NSE), and ROC matters.
                                Proven track record in managing board meetings, ensuring statutory compliance, and
                                leading shareholder communications across diverse corporate environments.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Team End -->


    <?php include("include/footer.php");?>
    <?php include("include/js.php");?>
</body>

</html>