<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("include/meta.php");?>
    <?php include("include/css.php");?>
</head>
<style>
.hover-scale {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.hover-scale:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1) !important;
}
</style>

<body>
    <?php include("include/preloader.php");?>
    <?php include("include/header.php");?>


    <!-- Page Header Start -->
    <div class="container-fluid page-header py-5 position-relative overflow-hidden">
        <video class="bg-video" autoplay muted loop playsinline>
            <source src="./images/banner.mp4" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <div class="video-overlay"></div>
        <div class="container py-5 position-relative z-1">
            <h1 class="display-3 text-white mb-3 animated slideInDown">Video Gallery</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a class="text-white" href="index.php">Home</a></li>
                    <li class="breadcrumb-item text-white active" aria-current="page">Video Gallery</li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- Projects Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mb-5">
                <h1 class="display-5 fw-bold text-dark mb-3">Our Video Gallery</h1>
                <p class="lead text-muted">Explore our latest videos and insights</p>
            </div>
            <div class="row g-4 justify-content-center">
                <?php                    
                $news_sql = "SELECT * FROM video WHERE v_by ='$x' ORDER BY v_id DESC";
                $news_run = mysqli_query($con, $news_sql);
                while ($news_rows = mysqli_fetch_assoc($news_run)) {
            ?>
                <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                    <div class="video-card shadow-sm rounded-3 overflow-hidden hover-scale">
                        <div class="ratio ratio-16x9">
                            <iframe src="https://www.youtube.com/embed/<?= $news_rows['video'] ?>"
                                title="<?= htmlspecialchars($news_rows['v_title']) ?>"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen class="rounded-top-3" loading="lazy">
                            </iframe>
                        </div>
                        <div class="p-3 bg-white">
                            <h6 class="fw-semibold text-dark mb-0 text-center">
                                <?= htmlspecialchars($news_rows['v_title']) ?>
                            </h6>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
    </div>

    <!-- Projects End -->


    <?php include("include/footer.php");?>
    <?php include("include/js.php");?>
</body>

</html>