<?php
session_start();
include "../db.php";
date_default_timezone_set('Asia/Kolkata');
$currentTime = date('M j, Y g:i a');

if (!isset($_SESSION['uid']) || !isset($_SESSION['uref']) || !isset($_SESSION['utype']) || !isset($_SESSION['uname'])) {
    header("Location: logout.php");
}
if(isset($_SESSION['cid'])) {
    // Assign 'cid' value to a session variable
    $cid = $_SESSION['cid'] ;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php include "includes/meta.php"; ?>
    <?php include "includes/css.php"; ?>
</head>

<body id="page-top" class="mt-55">
    <?php
    if (!isset($_GET['n_id']) || empty($_GET['n_id'])) {
        header("Location: notes-upload.php");
    }

    $n_id = $_GET['n_id'];
    $sql = mysqli_query($con, "SELECT * FROM notes WHERE n_id = '$n_id'");
    if ($row = mysqli_fetch_assoc($sql)) {
        $note_title = $row["n_title"];
        $n_class = $row["n_class"];
    }
    ?>
    <div style="margin-top: 130px;"></div>
    <?php include "includes/header2.php"; ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow mt-3">
                    <h5 class="card-header text-dark text-center font-weight-bold">Study Note -
                        <?php echo $note_title; ?> Videos</h5>
                    <div class="card-body">
                        <form method="POST" action="" enctype="multipart/form-data">
                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <label for="video">Enter video URL</label>
                                    <input type="text" class="form-control" name="video_url"
                                        placeholder="Enter embaded URL with Coma" required>
                                </div>
                            </div>

                            <div class="row justify-content-center">
                                <input type="hidden" value="<?php echo $n_id; ?>" name="note_id">
                                <input type="hidden" value="<?php echo $note_title; ?>" name="note_title">
                                <button type="submit" name="video_submit"
                                    class="btn btn-success text-sm-center mt-4">Upload Documents</button>
                                &nbsp;&nbsp;&nbsp;
                                <a href="view-notes.php?cid=<?php echo $n_class;?>"
                                    class="btn btn-warning text-sm-center mt-4">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div style="margin-top: 120px;"></div>
    <?php include "includes/ft.php"; ?>
    <?php include "includes/js.php"; ?>
</body>

</html>

<?php
if(isset($_POST['video_submit'])) {
    $note_id = $_POST["note_id"];
    $note_title = $_POST["note_title"];
    $video_url = $_POST["video_url"];

    // Split the string by commas
    $video_urls = explode(',', $video_url);

    // Variable to track successful uploads
    $success_count = 0;

    // Loop through each file
    foreach($video_urls as $url) {
        // Check if file is uploaded
        $insert_query = "INSERT INTO notes_img (ni_name, ni_type, ni_ref) VALUES ('$url', 'video', '$note_id')";
        mysqli_query($con, $insert_query); // Execute the insert query

        // Increment successful upload count
        $success_count++;
    } 
    
    $n_id = $note_id;
    $sql = mysqli_query($con, "SELECT * FROM notes WHERE n_id = '$n_id'");
    if ($row = mysqli_fetch_assoc($sql)) {
        $n_class = $row["n_class"];
    }

    // If at least one file was successfully uploaded
    if($success_count > 0) {
        // Show success alert and redirect
        echo '<script>alert("' . $success_count . ' Video Upload successful!");</script>';
        echo '<script>window.location = "view-notes.php?cid=' . $n_class . '";</script>';
        // Unset the session variable
        unset($_SESSION['cid']);
        exit; // Stop further execution
    } else {
        echo '<script>alert("No Video uploaded or all Video failed to upload.");</script>';
    }
}
?>