<?php
    session_start();
    include "../db.php";
    date_default_timezone_set('Asia/Kolkata');
    $currentTime = date('M j, Y g:i a');

    if ( !isset($_SESSION['uid']) && !isset($_SESSION['uref']) && !isset($_SESSION['utype']) && !isset($_SESSION['uname']) )
        header("Location: logout.php");

    if ( isset($_GET["ref"]) ) {
        $attendance_ref = $_GET["ref"];
    } else {
        header("Location: attendance.php");
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
 <?php include "includes/meta.php"; ?>        
    <?php include "includes/css.php"; ?>     


    <style>
        .update-info{
            position: fixed;
            z-index: 2;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 15.75rem;
            height: 3.75rem;
            text-align: center;
            color: #fff;
            background: rgba(94, 105, 111, 0.79);
            font-size: 25px;
            line-height: 60px;
            border-radius: 5px;
            box-shadow: 0px 8px 10px #000000a6;
        }
        .custom-control-label {
            text-align: center;
            background: #f1f1f1;
            height: 36px;
            width: 100px;
            padding: 7.4px;
            /* margin: 10px 20px 0 0; */
            color: #675f5f;
            font-weight: 500;
            font-size: 13px;
            cursor: pointer;
            box-shadow: 1px 3px 3px #d3cfcf;
            display: inline-block;
            transition: all 0.3s ease;
        }
        .custom-control-input:checked~.custom-control-label.present {
            background: green;
            color: #fff
        }
        .custom-control-input:checked~.custom-control-label.absent {
            background: red;
            color: #fff
        }
        .custom-control-label.active.present {
            background: green;
            color: #fff
        }
        .custom-control-label.active.absent {
            background: red;
            color: #fff
        }
        .custom-control-label::before, .custom-control-label::after {
            display: none;
        }
    </style>
</head>
<body id="page-top" class="mt-55">

<div class="update-info" style="display: none;"> Updating <i class="fas fa-spinner fa-pulse"></i> </div>

    <div style="margin-top: 80px;"></div>

      <?php include "includes/header2.php"; ?>
<?php 
    $att_sql= "SELECT * FROM attendance WHERE ref = '$attendance_ref'";
    $att_result = mysqli_query($con,$att_sql);
    $att_row = mysqli_fetch_assoc($att_result);
        $showCS = showClassSubjectFromSid($con,$att_row['class_period']);
        $showFullDate = showFullDate($att_row['class_date']);
        $showTime= showTime($att_row['class_time']);

 ?>
                <div class="container">

                    <div class="row justify-content-center">
                        <div class="col-md-6">
                            <div class="card shadow mb-4 mt-4">
                                <div class="card-header">
                                    <h1 class="h3 mb-2 text-gray-800 text-center">Student Attendance</h1>
                                    <p class="text-center" style="color: #116496;"><?php echo ' <i class="fa fa-clock-o"></i> '.$showFullDate.' '.$showTime.' &nbsp; <i class="fa fa-graduation-cap"></i> '.$showCS['showClass'].' &nbsp; <i class="fa fa-book"></i> '.$showCS['showSubject']; ?></p>
                                </div>
                                <div class="card-body">
                                    <!-- <form method="POST"> -->
                                        <div class="row m-0 justify-content-center">
                                            <div class="col-md-12 p-0" id="live_cart"></div>
                                        </div>
                                    <!-- </form> -->
                                </div>
                            </div>
                        </div>

                        <div class="col-12 text-center mb-4">
                            <a href="attendance.php" class="btn btn-primary">Attendance Complete</a>
                        </div>
                    </div>

                </div>

      <?php include "includes/ft.php"; ?>
       <?php include "includes/js.php"; ?>

    <script>
        $(function () {
            function fetch_data()
            {
                $.ajax({
                    url: "s-att-ajax1.php?ref=<?php echo $attendance_ref ?>",
                    method: "GET",
                    beforeSend: function () {
                        $('.update-info').show();
                    },
                    success: function(data){
                        $('#live_cart').html(data);
                        $('.update-info').addClass("d-none");
                    }
                });
            }

            fetch_data();

            $(document).on('click', '.attn', function(){
                var id = $(this).data("uref");
                var attn = $(this).data("attn");
                // console.log(id);

                $.ajax({
                    url:"s-att-ajax2.php",
                    method:"POST",
                    data:{
                        id:id,
                        attn:attn
                    },
                    dataType:"text",
                    beforeSend: function () {
                        $('.update-info').removeClass("d-none");
                        $('.update-info').show();
                    },
                    success:function(data){
                        // $('.cartCount').html(data);
                        // const Toast = Swal.mixin({
                        //     toast: true,
                        //     position: 'bottom',
                        //     showConfirmButton: false,
                        //     timer: 3000
                        // });
                        // Toast.fire({
                        //     type: 'success',
                        //     title: 'Cart Updated'
                        // });
                        fetch_data();
                        $('.update-info').addClass("d-none");
                    }
                });
            });
        });
    </script>

</body>
</html>