<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("./include/meta.php");?>
    <?php include("./include/css.php");?>
</head>

<body>
    <?php include("./include/nav.php");?>

    <!-- Header Start -->
    <div class="container-fluid page-header" style="margin-bottom: 90px;">
        <div class="container">
            <div class="d-flex flex-column justify-content-center" style="min-height: 300px">
                <h3 class="display-4 text-white text-uppercase">All Blog</h3>
                <div class="d-inline-flex text-white">
                    <p class="m-0 text-uppercase"><a class="text-white" href="index.php">Home</a></p>
                    <i class="fa fa-angle-double-right pt-1 px-3"></i>
                    <p class="m-0 text-uppercase">Blog</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Header End -->

    <!-- Blog Start -->
    <div class="container-fluid">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="row pb-3">
                        <?php
                            $items_per_page = 1; // Number of items per page
                            $page = isset($_GET['page']) ? $_GET['page'] : 1; // Current page number
                            $offset = ($page - 1) * $items_per_page; // Offset for the query
    
                            $blog_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'blog' AND data_recycle = '1' ORDER BY data_sl_no DESC LIMIT $offset, $items_per_page");
    
                            // Check if there are more than 20 items
                            $total_items = mysqli_num_rows(mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'blog' AND data_recycle = '1'"));
                            $total_pages = ceil($total_items / $items_per_page);
                        ?>
                        <?php while($blog_row = mysqli_fetch_assoc($blog_sql)) { ?>
                        <div class="col-lg-6 mb-3">
                            <div class="blog-item position-relative overflow-hidden rounded mb-2"
                                style="height: 350px;">
                                <img class="img-fluid" src="./login/upload/<?php echo $blog_row["data_img"];?>"
                                    alt="<?php echo $blog_row["data_title"];?>" style="height: 350px;">
                                <a class="blog-overlay text-decoration-none"
                                    href="blog-details.php?blog_id=<?php echo $blog_row["data_sl_no"];?>">
                                    <h5 class="text-white mb-3"><?php echo $blog_row["data_title"];?></h5>
                                    <p class="text-primary m-0"><?php echo $blog_row["data_up_date"];?></p>
                                </a>
                            </div>
                        </div>
                        <?php } ?>

                        <!-- Pagination -->
                        <?php if ($total_pages > 1) { ?>
                        <div class="col-12">
                            <nav aria-label="Page navigation">
                                <ul class="pagination pagination-lg justify-content-center mb-0">
                                    <li class="page-item <?php echo ($page <= 1) ? 'disabled' : ''; ?>">
                                        <a class="page-link" href="blog.php?page=<?php echo ($page - 1); ?>"
                                            aria-label="Previous">
                                            <span aria-hidden="true">&laquo;</span>
                                            <span class="sr-only">Previous</span>
                                        </a>
                                    </li>
                                    <?php for ($i = 1; $i <= $total_pages; $i++) { ?>
                                    <li class="page-item <?php echo ($page == $i) ? 'active' : ''; ?>"><a
                                            class="page-link"
                                            href="blog.php?page=<?php echo $i; ?>"><?php echo $i; ?></a></li>
                                    <?php } ?>
                                    <li class="page-item <?php echo ($page >= $total_pages) ? 'disabled' : ''; ?>">
                                        <a class="page-link" href="blog.php?page=<?php echo ($page + 1); ?>"
                                            aria-label="Next">
                                            <span aria-hidden="true">&raquo;</span>
                                            <span class="sr-only">Next</span>
                                        </a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                        <?php } ?>
                    </div>
                </div>

                <div class="col-md-4">
                    <!-- Category List -->
                    <div class="mb-5">
                        <div class="sidebar">
                            <h3 class="text-uppercase mb-4" style="letter-spacing: 5px;">Courses</h3>
                            <ul class="list-group list-group-flush">
                                <?php
                                $course_list = mysqli_query($con, "SELECT * FROM courses WHERE course_recycle = '1'");
                                while($course_list_row = mysqli_fetch_assoc($course_list)){
                                    $dept_sl = $course_list_row["course_dept"];
                                            $dept_name_sql = mysqli_query($con, "SELECT * FROM department WHERE dept_id = '$dept_sl'");
                                            if($dept_name_row = mysqli_fetch_assoc($dept_name_sql)){
                                                $department_name = $dept_name_row["dept_name"];
                                            }
                                ?>
                                <li class="list-group-item d-flex align-items-center px-0">
                                    <a href="course.php?dept=<?php echo $department_name;?>&course_name=<?php echo $course_list_row["course_name"];?>"
                                        class="text-decoration-none h6 m-0 "><?php echo $course_list_row["course_name"];?>
                                        <span class="badge badge-primary badge-pill"
                                            style="font-size:8px;"><?php echo $department_name;?></span>
                                </li>
                                <?php }?>
                            </ul>
                        </div>
                    </div>

                    <!-- Recent Post -->
                    <div class="mb-5">
                        <div class="sidebar2">
                            <h3 class="text-uppercase mb-3" style="letter-spacing: 5px;">Recent Blogs</h3>
                            <?php
                                $blog_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'blog' AND data_recycle = '1' ORDER BY data_sl_no DESC LIMIT 3");
                                while($blog_row = mysqli_fetch_assoc($blog_sql)){
                            ?>
                            <a class="d-flex align-items-center text-decoration-none mb-3"
                                href="blog-details.php?blog_id=<?php echo $blog_row["data_sl_no"];?>">
                                <img class="img-fluid rounded" style="height:50px;"
                                    src="./login/upload/<?php echo $blog_row["data_img"];?>"
                                    alt="<?php echo $blog_row["data_title"];?>">
                                <div class="pl-3">
                                    <h6 class="m-1"><?php echo $blog_row["data_title"];?></h6>
                                    <small><?php echo $blog_row["data_up_date"];?></small>
                                </div>
                            </a>
                            <?php }?>
                        </div>
                    </div>

                    <!-- Latest Noteic -->
                    <div class="mb-5">
                        <div class="sidebar3">
                            <h3 class="text-uppercase text-white mb-3" style="letter-spacing: 5px;">Latest Notice</h3>
                            <div class="d-flex flex-wrap m-n1">
                                <?php
                                    $notice_sql = mysqli_query($con, "SELECT * FROM notice WHERE notice_recycle = '1' ORDER BY notice_id DESC");
                                    while ($notice_row = mysqli_fetch_assoc($notice_sql)) {
                                ?>
                                <a href="notice.php" class="m-1 sidebar-notice">
                                    <?php echo $notice_row["notice_name"]; ?>
                                    <?php
                                $notice_create_date = $notice_row["notice_creatdate"];

                                // Convert the notice create date to a DateTime object
                                $notice_create_datetime = DateTime::createFromFormat('M d, Y g:i a', $notice_create_date);

                                // Add 7 days to the notice create date
                                $notice_expiry_datetime = clone $notice_create_datetime;
                                $notice_expiry_datetime->modify('+15 days');

                                // Current date
                                $current_date = new DateTime();

                                if ($current_date <= $notice_expiry_datetime) {
                            ?>
                                    <img class="blink" src="./img/new.webp" alt="Your Image">
                                    <?php } ?>
                                </a>
                                <br>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blog End -->


    <!-- Footer Start -->
    <div class="container-fluid bg-dark text-white py-5 px-sm-3 px-lg-5" style="margin-top: 90px;">
        <div class="row pt-5">
            <div class="col-lg-7 col-md-12">
                <div class="row">
                    <div class="col-md-6 mb-5">
                        <h5 class="text-primary text-uppercase mb-4" style="letter-spacing: 5px;">Get In Touch</h5>
                        <p><i class="fa fa-map-marker-alt mr-2"></i>123 Street, New York, USA</p>
                        <p><i class="fa fa-phone-alt mr-2"></i>+012 345 67890</p>
                        <p><i class="fa fa-envelope mr-2"></i>info@example.com</p>
                        <div class="d-flex justify-content-start mt-4">
                            <a class="btn btn-outline-light btn-square mr-2" href="#"><i class="fab fa-twitter"></i></a>
                            <a class="btn btn-outline-light btn-square mr-2" href="#"><i
                                    class="fab fa-facebook-f"></i></a>
                            <a class="btn btn-outline-light btn-square mr-2" href="#"><i
                                    class="fab fa-linkedin-in"></i></a>
                            <a class="btn btn-outline-light btn-square" href="#"><i class="fab fa-instagram"></i></a>
                        </div>
                    </div>
                    <div class="col-md-6 mb-5">
                        <h5 class="text-primary text-uppercase mb-4" style="letter-spacing: 5px;">Our Courses</h5>
                        <div class="d-flex flex-column justify-content-start">
                            <a class="text-white mb-2" href="#"><i class="fa fa-angle-right mr-2"></i>Web Design</a>
                            <a class="text-white mb-2" href="#"><i class="fa fa-angle-right mr-2"></i>Apps Design</a>
                            <a class="text-white mb-2" href="#"><i class="fa fa-angle-right mr-2"></i>Marketing</a>
                            <a class="text-white mb-2" href="#"><i class="fa fa-angle-right mr-2"></i>Research</a>
                            <a class="text-white" href="#"><i class="fa fa-angle-right mr-2"></i>SEO</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 col-md-12 mb-5">
                <h5 class="text-primary text-uppercase mb-4" style="letter-spacing: 5px;">Newsletter</h5>
                <p>Rebum labore lorem dolores kasd est, et ipsum amet et at kasd, ipsum sea tempor magna tempor. Accu
                    kasd sed ea duo ipsum. Dolor duo eirmod sea justo no lorem est diam</p>
                <div class="w-100">
                    <div class="input-group">
                        <input type="text" class="form-control border-light" style="padding: 30px;"
                            placeholder="Your Email Address">
                        <div class="input-group-append">
                            <button class="btn btn-primary px-4">Sign Up</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid bg-dark text-white border-top py-4 px-sm-3 px-md-5"
        style="border-color: rgba(256, 256, 256, .1) !important;">
        <div class="row">
            <div class="col-lg-6 text-center text-md-left mb-3 mb-md-0">
                <p class="m-0 text-white">&copy; <a href="#">Domain Name</a>. All Rights Reserved. Designed by <a
                        href="https://htmlcodex.com">HTML Codex</a>
                </p>
            </div>
            <div class="col-lg-6 text-center text-md-right">
                <ul class="nav d-inline-flex">
                    <li class="nav-item">
                        <a class="nav-link text-white py-0" href="#">Privacy</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white py-0" href="#">Terms</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white py-0" href="#">FAQs</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white py-0" href="#">Help</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- Footer End -->


    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="fa fa-angle-double-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Contact Javascript File -->
    <script src="mail/jqBootstrapValidation.min.js"></script>
    <script src="mail/contact.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>