<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("./include/meta.php");?>
    <?php include("./include/css.php");?>
</head>

<body>
    <?php include("./include/nav.php");?>

    <!-- Header Start -->
    <div class="container-fluid page-header" style="margin-bottom: 90px;">
        <div class="container">
            <div class="d-flex flex-column justify-content-center" style="min-height: 300px">
                <h3 class="display-4 text-white text-uppercase">Image Gallery</h3>
                <div class="d-inline-flex text-white">
                    <p class="m-0 text-uppercase"><a class="text-white" href="index.php">Home</a></p>
                    <i class="fa fa-angle-double-right pt-1 px-3"></i>
                    <p class="m-0 text-uppercase">Gallery</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Header End -->

    <!-- Gallery start -->
    <div class="container-fluid">
        <div class="container py-5">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Gallery</h5>
                <h1>Our Image Gallery</h1>
            </div>
            <?php
                $img_g_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'image gallery' AND data_recycle = '1' ORDER by data_sl_no DESC");
                // Initialize an array to store all image data
                $imageData = array();
                while ($img_g_row = mysqli_fetch_assoc($img_g_sql)) {
                    $imageData[] = $img_g_row;
                }
            ?>
            <div id="gallery" class="photos-grid-container gallery">
                <?php $firstImageDisplayed = false; ?>
                <?php foreach ($imageData as $img_g_row) : ?>
                <?php if (!$firstImageDisplayed) : ?>
                <div class="main-photo img-box">
                    <a href="./login/upload/<?php echo $img_g_row["data_img"]; ?>" class="glightbox"
                        data-glightbox="type: image">
                        <img src="./login/upload/<?php echo $img_g_row["data_img"]; ?>" style="height:440px;"
                            alt="<?php echo $img_g_row["data_title"]; ?>" />
                    </a>
                </div>
                <?php $firstImageDisplayed = true; ?>
                <?php endif; ?>
                <?php endforeach; ?>
                <div>
                    <div class="sub">
                        <?php $imageCount = count($imageData); ?>
                        <?php for ($i = 1; $i < 4; $i++) : ?>
                        <div class="img-box">
                            <a href="./login/upload/<?php echo $imageData[$i]["data_img"]; ?>" class="glightbox"
                                data-glightbox="type: image">
                                <img src="./login/upload/<?php echo $imageData[$i]["data_img"]; ?>"
                                    style="height:220px;" alt="<?php echo $imageData[$i]["data_title"]; ?>" />
                            </a>
                        </div>
                        <?php endfor; ?>
                        <?php if ($imageCount > 3) : ?>
                        <div id="multi-link" class="img-box">
                            <a href="./login/upload/<?php echo $imageData[4]["data_img"]; ?>" class="glightbox"
                                data-glightbox="type: image">
                                <img src="./login/upload/<?php echo $imageData[4]["data_img"]; ?>"
                                    alt="<?php echo $imageData[4]["data_title"]; ?>" />
                                <div class="transparent-box">
                                    <div class="caption">
                                        +<?php echo $imageCount - 5; ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div id="more-img" class="extra-images-container hide-element">
                    <?php foreach ($imageData as $img_g_row) : ?>
                    <?php if ($img_g_row !== $imageData[0]) : ?>
                    <a href="./login/upload/<?php echo $img_g_row["data_img"]; ?>" class="glightbox"
                        data-glightbox="type: image">
                        <img src="./login/upload/<?php echo $img_g_row["data_img"]; ?>"
                            alt="<?php echo $img_g_row["data_title"]; ?>" />
                    </a>
                    <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- Gallery end -->


    <?php include("./include/footer.php");?>
    <?php include("./include/js.php");?>
</body>

</html>