<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("./include/meta.php");?>
    <?php include("./include/css.php");?>
</head>

<body>
    <?php include("./include/nav.php");?>

    <!-- Carousel Start -->
    <div class="container-fluid p-0" style="position:relative;">
        <div id="header-carousel" class="carousel slide carousel-fade" data-ride="carousel">
            <ol class="carousel-indicators">
                <?php
                    $banner_sql = "SELECT * FROM slider WHERE s_recycle = '1' ";
                    $banner_run = mysqli_query($con, $banner_sql);
                    $indicatorIndex = 0;
                    while ($row = mysqli_fetch_assoc($banner_run)) {
                        $activeClass = $indicatorIndex === 0 ? 'active' : '';
                ?>
                <li data-target="#header-carousel" data-slide-to="<?php echo $indicatorIndex; ?>"
                    class="<?php echo $activeClass; ?>"></li>
                <?php
                        $indicatorIndex++;
                    }
                ?>
            </ol>
            <div class="carousel-inner">
                <?php
                    $banner_sql = "SELECT * FROM slider WHERE s_recycle = '1' ";
                    $banner_run = mysqli_query($con, $banner_sql);
                    $firstItem = true; // Flag to track the active item
                    while ($row = mysqli_fetch_assoc($banner_run)) {
                        $activeClass = $firstItem ? 'active' : '';
                ?>
                <div class="carousel-item <?php echo $activeClass; ?>" style="min-height: 300px;">
                    <img class="position-relative w-100" src="./login/upload/<?php echo $row['s_img']; ?>"
                        style="min-height: 300px; object-fit: cover;">
                    <div class="carousel-caption d-flex align-items-center justify-content-center">
                        <div class="p-5" style="width: 100%; max-width: 900px;">
                            <h3 class="text-white text-uppercase mb-md-3"><?php echo $row['s_name']; ?></h3>
                            <p class="text-white mb-md-4"> <?php echo $row['s_about']; ?></p>
                            <a href="" class="btn btn-primary py-md-2 px-md-4 font-weight-semi-bold mt-2">Learn More</a>
                        </div>
                    </div>
                </div>
                <?php
                        $firstItem = false; // Set the flag to false after the first iteration
                    }
                ?>
            </div>
        </div>
        <div class="service1-inner-area">
            <div class="container">
                <div class="row service1-wrapper">
                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 service-box1">
                        <div class="service-box-content">
                            <h3 style="color:#fff;"><a href="#">WHY US</a></h3>
                            <p>The Institute is affiliated to
                                MAKAUT and all courses are approved by AICTE.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 service-box1">
                        <div class="service-box-content">
                            <h3 style="color:#fff;"><a href="#">RESEARCH &
                                    EXTENSION</a></h3>
                            <p>To organize seminar & workshop
                                Work will start from the coming semester.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 service-box1">
                        <div class="service-box-content">
                            <h3 style="color:#fff;"><a href="#">ADMISSION OPEN</a></h3>
                            <p>CONTACT IMMEDIATELY TO AVAIL
                                SCHOLARSHIP CALL AT (+91)9999999999/9999999999</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Carousel End -->

    <!-- About Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <?php 
                $about_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'single_page' AND data_title = 'ABOUT' AND data_recycle = '1' ");
                if($about_row = mysqli_fetch_assoc($about_sql)){
            ?>
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <img class="img-fluid rounded mb-4 mb-lg-0"
                        src="./login/upload/about/<?php echo $about_row["data_img"];?>" alt="">
                </div>
                <div class="col-lg-7">
                    <div class="text-left mb-4">
                        <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">About Us</h5>
                        <h2><?php echo $about_row["data_short_des"];?></h2>
                    </div>
                    <p><?php echo $about_row["data_long_des"];?></p>
                    <a href="about.php" class="btn btn-primary py-md-2 px-md-4 font-weight-semi-bold mt-2">Learn
                        More</a>
                </div>
            </div>
            <?php }?>
        </div>
    </div>
    <!-- About End -->


    <!-- Course Start -->
    <div class="container-fluid py-5" style="background:#f3f3f3;">
        <div class="container pt-5 pb-3">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Courses</h5>
                <h1>Explore Top Courses</h1>
            </div>
            <div class="row">
                <?php 
                    $course_sql = mysqli_query($con, "SELECT * FROM courses WHERE course_recycle = '1' limit 8");
                    while($course_row = mysqli_fetch_assoc($course_sql)){
                ?>
                <div class="col-lg-3 col-md-6 mb-4">
                    <div class="cat-item position-relative overflow-hidden rounded mb-2" style="height: 170px;">
                        <img class="img-fluid" src="./login/upload/<?php echo $course_row["course_img"];?>"
                            style="height: 170px;" alt="<?php echo $course_row["course_name"];?>">
                        <a class="cat-overlay text-white text-decoration-none"
                            href="course.php?dept=<?php echo $dept_row['dept_name'];?>&course_name=<?php echo $course_row["course_name"];?>">
                            <h4 class="text-white text-center font-weight-medium">
                                <?php echo $course_row["course_name"];?>
                            </h4>
                            <span style="color: #dcc346">
                                <?php
                                    $dept_sql = mysqli_query($con, "SELECT * FROM department WHERE dept_recycle = '1' AND dept_id = '$course_row[course_dept]' ");
                                    if($dept_row = mysqli_fetch_assoc($dept_sql)){
                                        echo "( " . $dept_row['dept_name'] . " )";
                                    }
                                ?>
                            </span>
                        </a>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
    <!-- Course Start -->


    <!-- Notice Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Notice</h5>
                <h1>Our Latest Notice</h1>
            </div>
            <div class="row">
                <?php
                    $notice_sql = mysqli_query($con, "SELECT * FROM notice WHERE notice_recycle = '1' ORDER BY notice_id DESC limit 3");
                    while($notice_row = mysqli_fetch_assoc($notice_sql)){
                ?>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="rounded overflow-hidden mb-2">
                        <div class="bg-secondary p-3">
                            <a class="h5" href="notice.php"><?php echo $notice_row["notice_name"]; ?></a>
                            <?php
                                $notice_create_date = $notice_row["notice_creatdate"];

                                // Convert the notice create date to a DateTime object
                                $notice_create_datetime = DateTime::createFromFormat('M d, Y g:i a', $notice_create_date);

                                // Add 7 days to the notice create date
                                $notice_expiry_datetime = clone $notice_create_datetime;
                                $notice_expiry_datetime->modify('+15 days');

                                // Current date
                                $current_date = new DateTime();

                                if ($current_date <= $notice_expiry_datetime) {
                            ?>
                            <img class="blink" src="./img/new.webp" alt="Your Image">
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
    <!-- Notice End -->


    <!-- Registration Start -->
    <div class="container-fluid bg-registration py-5" style="margin: 90px 0;">
        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-7 mb-5 mb-lg-0">
                    <div class="mb-4">
                        <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Need Any Courses</h5>
                        <h1 class="text-white">30% Off For New Students</h1>
                    </div>
                    <p class="text-white">Invidunt lorem justo sanctus clita. Erat lorem labore ea, justo dolor lorem
                        ipsum ut sed eos,
                        ipsum et dolor kasd sit ea justo. Erat justo sed sed diam. Ea et erat ut sed diam sea ipsum est
                        dolor</p>
                    <ul class="list-inline text-white m-0">
                        <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Labore eos amet dolor amet diam
                        </li>
                        <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Etsea et sit dolor amet ipsum</li>
                        <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Diam dolor diam elitripsum vero.
                        </li>
                    </ul>
                </div>
                <div class="col-lg-5">
                    <div class="card border-0">
                        <div class="card-header bg-light text-center p-4">
                            <h1 class="m-0">Sign Up Now</h1>
                        </div>
                        <div class="card-body rounded-bottom p-5" style="background:#dcc346;">
                            <form action="" method="POST">
                                <div class="form-group">
                                    <input type="text" class="form-control border-0 p-4" name="con_name"
                                        placeholder="Your name" required="required" />
                                </div>
                                <div class="form-group">
                                    <input type="tel" name="form_phone" class="form-control border-0 p-4"
                                        placeholder="Mobile Number" required="required" />
                                </div>
                                <div class="form-group">
                                    <input type="email" name="con_email" class="form-control border-0 p-4"
                                        placeholder="Your email" required="required" />
                                </div>
                                <div class="form-group">
                                    <select name="con_subject" class="custom-select border-0 px-4"
                                        style="height: 47px;">
                                        <option selected>Select a course</option>
                                        <?php 
                                            $co_sql = mysqli_query($con, "SELECT * FROM courses WHERE course_recycle = '1' ");
                                            while($co_row = mysqli_fetch_assoc($co_sql)){
                                        ?>
                                        <option value="<?php echo $co_row["course_name"];?><?php
                                                    $de_sql = mysqli_query($con, "SELECT * FROM department WHERE dept_recycle = '1' AND dept_id = '$co_row[course_dept]' ");
                                                    if($de_row = mysqli_fetch_assoc($de_sql)){
                                                        echo "( " . $de_row['dept_name'] . " )";
                                                    }
                                                    ?>"><?php echo $co_row["course_name"];?>
                                            <?php echo "( " . $de_row['dept_name'] . " )";?>
                                        </option>
                                        <?php }?>
                                    </select>
                                </div>
                                <div class="form-group" style="position:relative;">
                                    <input type="text" class="form-control border-0 p-4" id="capcha" name="capcha"
                                        placeholder="Enter Captcha" required="required" />
                                    <?php
                                        $random_code = rand(1000, 9999);
                                    ?>
                                    <p style="position: absolute;right: 0;top: 13px;">
                                        <span
                                            style="background: #084e30;padding: 13px 13px;color: #fff;border-radius: 0px 8px 8px 0px;"><?php echo $random_code;?></span>
                                    </p>
                                    <input type="hidden" value="<?php echo $random_code;?>" name="or_code">
                                </div>
                                <div>
                                    <button class="btn btn-dark btn-block border-0 py-3" style="background:#d7090b;"
                                        name="form_submit" type="submit">Enquiry Now !</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Registration End -->


    <!-- Team Start -->
    <div class="container-fluid py-5">
        <div class="container pt-5 pb-3">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Teachers</h5>
                <h1>Meet Our Teachers</h1>
            </div>
            <div class="row">
                <?php
                    $faculty_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'faculty' AND data_recycle = '1' ORDER BY data_sl_no DESC LIMIT 4");
                    while($faculty_row = mysqli_fetch_assoc($faculty_sql)){
                ?>
                <div class="col-md-6 col-lg-3 text-center team mb-4">
                    <div class="team-item rounded overflow-hidden mb-2">
                        <div class="team-img position-relative">
                            <img class="img-fluid" src="./login/upload/<?php echo $faculty_row["data_img"];?>"
                                alt="<?php echo $faculty_row["data_title"];?>">
                        </div>
                        <div class="bg-secondary p-4">
                            <h5><?php echo $faculty_row["data_title"];?></h5>
                            <p class="m-0"><?php echo $faculty_row["data_short_des"];?></p>
                        </div>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
    <!-- Team End -->

    <!-- Gallery start -->
    <div class="container-fluid py-5" style="background:#f3f3f3;">
        <div class="container py-5">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Gallery</h5>
                <h1>See Our Gallery</h1>
            </div>
            <?php
                $img_g_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'image gallery' AND data_recycle = '1' ORDER by data_sl_no DESC");
                // Initialize an array to store all image data
                $imageData = array();
                while ($img_g_row = mysqli_fetch_assoc($img_g_sql)) {
                    $imageData[] = $img_g_row;
                }
            ?>
            <div id="gallery" class="photos-grid-container gallery">
                <?php $firstImageDisplayed = false; ?>
                <?php foreach ($imageData as $img_g_row) : ?>
                <?php if (!$firstImageDisplayed) : ?>
                <div class="main-photo img-box">
                    <a href="./login/upload/<?php echo $img_g_row["data_img"]; ?>" class="glightbox"
                        data-glightbox="type: image">
                        <img src="./login/upload/<?php echo $img_g_row["data_img"]; ?>" style="height:440px;"
                            alt="<?php echo $img_g_row["data_title"]; ?>" />
                    </a>
                </div>
                <?php $firstImageDisplayed = true; ?>
                <?php endif; ?>
                <?php endforeach; ?>
                <div>
                    <div class="sub">
                        <?php $imageCount = count($imageData); ?>
                        <?php for ($i = 1; $i < 4; $i++) : ?>
                        <div class="img-box">
                            <a href="./login/upload/<?php echo $imageData[$i]["data_img"]; ?>" class="glightbox"
                                data-glightbox="type: image">
                                <img src="./login/upload/<?php echo $imageData[$i]["data_img"]; ?>"
                                    style="height:220px;" alt="<?php echo $imageData[$i]["data_title"]; ?>" />
                            </a>
                        </div>
                        <?php endfor; ?>
                        <?php if ($imageCount > 3) : ?>
                        <div id="multi-link" class="img-box">
                            <a href="./login/upload/<?php echo $imageData[4]["data_img"]; ?>" class="glightbox"
                                data-glightbox="type: image">
                                <img src="./login/upload/<?php echo $imageData[4]["data_img"]; ?>"
                                    alt="<?php echo $imageData[4]["data_title"]; ?>" />
                                <div class="transparent-box">
                                    <div class="caption">
                                        +<?php echo $imageCount - 5; ?>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div id="more-img" class="extra-images-container hide-element">
                    <?php foreach ($imageData as $img_g_row) : ?>
                    <?php if ($img_g_row !== $imageData[0]) : ?>
                    <a href="./login/upload/<?php echo $img_g_row["data_img"]; ?>" class="glightbox"
                        data-glightbox="type: image">
                        <img src="./login/upload/<?php echo $img_g_row["data_img"]; ?>"
                            alt="<?php echo $img_g_row["data_title"]; ?>" />
                    </a>
                    <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- Gallery end -->


    <!-- Testimonial Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Testimonial</h5>
                <h1>What Say Our Students</h1>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="owl-carousel testimonial-carousel">
                        <?php 
                            $testimonial_sql = mysqli_query($con, "SELECT * FROM testimonial WHERE testimoni_recycle = '1' ORDER BY testimoni_id DESC");
                            while($testimonial_row = mysqli_fetch_assoc($testimonial_sql)){
                        ?>
                        <div class="text-center">
                            <i class="fa fa-3x fa-quote-left text-primary mb-4"></i>
                            <h4 class="font-weight-normal mb-4"><?php echo $testimonial_row["testimoni_des"];?></h4>
                            <img class="img-fluid mx-auto mb-3"
                                src="./login/upload/<?php echo $testimonial_row["testimoni_img"];?>"
                                alt="<?php echo $testimonial_row["testimoni_name"];?>">
                            <h5 class="m-0"><?php echo $testimonial_row["testimoni_name"];?></h5>
                            <span><?php echo $testimonial_row["testimoni_designation"];?></span>
                        </div>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Testimonial End -->


    <!-- Blog Start -->
    <div class="container-fluid py-5" style="background:#f3f3f3;">
        <div class="container pt-5 pb-3">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Our Blog</h5>
                <h1>Latest From Our Blog</h1>
            </div>
            <div class="row pb-3">
                <?php
                    $blog_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'blog' AND data_recycle = '1' ORDER BY data_sl_no DESC LIMIT 5");
                    while($blog_row = mysqli_fetch_assoc($blog_sql)){
                ?>
                <div class="col-lg-4 mb-4">
                    <div class="blog-item position-relative overflow-hidden rounded mb-2" style="height: 350px;">
                        <img class="img-fluid" src="./login/upload/<?php echo $blog_row["data_img"];?>"
                            alt="<?php echo $blog_row["data_title"];?>" style="height: 350px;">
                        <a class="blog-overlay text-decoration-none"
                            href="blog-details.php?blog_id=<?php echo $blog_row["data_sl_no"];?>">
                            <h5 class="text-white mb-3"><?php echo $blog_row["data_title"];?></h5>
                            <p class="text-primary m-0"><?php echo $blog_row["data_up_date"];?></p>
                        </a>
                    </div>
                </div>
                <?php }?>
            </div>
        </div>
    </div>
    <!-- Blog End -->

    <!-- Placement Partners -->
    <section class="clients"
        style="background: #dcc346;position: absolute;width: 100%;padding: 10px;height: 100px;z-index: 0;">
        <div class="container pt-10 pb-0">
            <div class="row">
                <div class="col-md-12">
                    <div class="owl-carousel clients-logo">
                        <?php
                            $training_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'training-placement-partner' AND data_recycle = '1' ORDER BY data_sl_no DESC");
                            while($training_row = mysqli_fetch_assoc($training_sql)){
                            ?>
                        <div class="item"> <a href="#"><img src="./login/upload/<?php echo $training_row["data_img"];?>"
                                    alt="Placement Partner"></a>
                        </div>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Placement Partners -->

    <?php include("./include/footer.php");?>
    <?php include("./include/js.php");?>

</body>

</html>

<?php
if (isset($_POST["form_submit"])) {
    // Escape user inputs for security
    $con_name = $con->real_escape_string($_POST['con_name']);
    $con_email = $con->real_escape_string($_POST['con_email']);
    $con_subject = $con->real_escape_string($_POST['con_subject']);
    $form_phone = $con->real_escape_string($_POST['form_phone']);

    $capcha = $_POST['capcha'];
    $or_code = $_POST['or_code'];

    if($capcha == $or_code){

    // Insert into database
    $sql = "INSERT INTO contact (con_name, con_email, con_subject, con_no, con_creatdate, con_type)
    VALUES ('$con_name', '$con_email', '$con_subject', '$form_phone', NOW(), 'Index Registration')";

    if ($con->query($sql) === TRUE) {
        echo "<script>alert('Form submitted successfully.'); window.location.href = 'index.php';</script>";
    } else {
        echo "Error: " . $sql . "<br>" . $con->error;
    }
}
}
?>