(function ($) {
  "use strict";

  // Dropdown on mouse hover
  $(document).ready(function () {
    function toggleNavbarMethod() {
      if ($(window).width() > 992) {
        $(".navbar .dropdown")
          .on("mouseover", function () {
            $(".dropdown-toggle", this).trigger("click");
          })
          .on("mouseout", function () {
            $(".dropdown-toggle", this).trigger("click").blur();
          });
      } else {
        $(".navbar .dropdown").off("mouseover").off("mouseout");
      }
    }
    toggleNavbarMethod();
    $(window).resize(toggleNavbarMethod);
  });

  // Back to top button
  $(window).scroll(function () {
    if ($(this).scrollTop() > 100) {
      $(".back-to-top").fadeIn("slow");
    } else {
      $(".back-to-top").fadeOut("slow");
    }
  });
  $(".back-to-top").click(function () {
    $("html, body").animate({ scrollTop: 0 }, 1500, "easeInOutExpo");
    return false;
  });

  // Testimonials carousel
  $(".testimonial-carousel").owlCarousel({
    autoplay: true,
    smartSpeed: 500,
    dots: true,
    loop: true,
    items: 1,
  });
  // clients-logo carousel
  $(".clients-logo").owlCarousel({
    autoplay: true,
    smartSpeed: 500,
    dots: true,
    loop: true,
    responsive: {
      0: {
        items: 1, // Display 1 item on mobile
      },
      768: {
        items: 4, // Display 4 items on tablets
      },
      992: {
        items: 6, // Display 6 items on desktop
      },
    },
  });
})(jQuery);
