<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("./include/meta.php");?>
    <?php include("./include/css.php");?>
</head>

<body>
    <?php include("./include/nav.php");?>

    <!-- Header Start -->
    <div class="container-fluid page-header" style="margin-bottom: 90px;">
        <div class="container">
            <div class="d-flex flex-column justify-content-center" style="min-height: 300px">
                <h3 class="display-4 text-white text-uppercase">About</h3>
                <div class="d-inline-flex text-white">
                    <p class="m-0 text-uppercase"><a class="text-white" href="index.php">Home</a></p>
                    <i class="fa fa-angle-double-right pt-1 px-3"></i>
                    <p class="m-0 text-uppercase">About</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Header End -->


    <!-- About Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <?php 
                $about_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'single_page' AND data_title = 'ABOUT' AND data_recycle = '1' ");
                if($about_row = mysqli_fetch_assoc($about_sql)){
            ?>
            <div class="row align-items-center">
                <div class="col-lg-5">
                    <img class="img-fluid rounded mb-4 mb-lg-0"
                        src="./login/upload/about/<?php echo $about_row["data_img"];?>" alt="">
                </div>
                <div class="col-lg-7">
                    <div class="text-left mb-4">
                        <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">About Us</h5>
                        <h2><?php echo $about_row["data_short_des"];?></h2>
                    </div>
                    <p><?php echo $about_row["data_long_des"];?></p>
                </div>
                <div class="col-lg-12">
                    <p><?php echo $about_row["data_seo_tag"];?></p>
                </div>
            </div>
            <?php }?>
        </div>
    </div>
    <!-- About End -->


    <!-- Registration Start -->
    <div class="container-fluid bg-registration py-5" style="margin: 90px 0;">
        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-7 mb-5 mb-lg-0">
                    <div class="mb-4">
                        <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Need Any Courses</h5>
                        <h1 class="text-white">30% Off For New Students</h1>
                    </div>
                    <p class="text-white">Invidunt lorem justo sanctus clita. Erat lorem labore ea, justo dolor lorem
                        ipsum ut sed eos,
                        ipsum et dolor kasd sit ea justo. Erat justo sed sed diam. Ea et erat ut sed diam sea ipsum est
                        dolor</p>
                    <ul class="list-inline text-white m-0">
                        <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Labore eos amet dolor amet diam
                        </li>
                        <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Etsea et sit dolor amet ipsum</li>
                        <li class="py-2"><i class="fa fa-check text-primary mr-3"></i>Diam dolor diam elitripsum vero.
                        </li>
                    </ul>
                </div>
                <div class="col-lg-5">
                    <div class="card border-0">
                        <div class="card-header bg-light text-center p-4">
                            <h1 class="m-0">Sign Up Now</h1>
                        </div>
                        <div class="card-body rounded-bottom p-5" style="background:#dcc346;">
                            <form>
                                <div class="form-group">
                                    <input type="text" class="form-control border-0 p-4" placeholder="Your name"
                                        required="required" />
                                </div>
                                <div class="form-group">
                                    <input type="tel" class="form-control border-0 p-4" placeholder="Mobile Number"
                                        required="required" />
                                </div>
                                <div class="form-group">
                                    <input type="email" class="form-control border-0 p-4" placeholder="Your email"
                                        required="required" />
                                </div>
                                <div class="form-group">
                                    <select class="custom-select border-0 px-4" style="height: 47px;">
                                        <option selected>Select a course</option>
                                        <?php 
                                            $co_sql = mysqli_query($con, "SELECT * FROM courses WHERE course_recycle = '1' ");
                                            while($co_row = mysqli_fetch_assoc($co_sql)){
                                        ?>
                                        <option value="<?php echo $co_row["course_name"];?><?php
                                                    $de_sql = mysqli_query($con, "SELECT * FROM department WHERE dept_recycle = '1' AND dept_id = '$co_row[course_dept]' ");
                                                    if($de_row = mysqli_fetch_assoc($de_sql)){
                                                        echo "( " . $de_row['dept_name'] . " )";
                                                    }
                                                    ?>"><?php echo $co_row["course_name"];?>
                                            <?php echo "( " . $de_row['dept_name'] . " )";?>
                                        </option>
                                        <?php }?>
                                    </select>
                                </div>
                                <div>
                                    <button class="btn btn-dark btn-block border-0 py-3" style="background:#d7090b;"
                                        type="submit">Sign Up
                                        Now</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Registration End -->


    <!-- Testimonial Start -->
    <div class="container-fluid py-5">
        <div class="container py-5">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Testimonial</h5>
                <h1>What Say Our Students</h1>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="owl-carousel testimonial-carousel">
                        <?php 
                        $testimonial_sql = mysqli_query($con, "SELECT * FROM testimonial WHERE testimoni_recycle = '1' ORDER BY testimoni_id DESC");
                        while($testimonial_row = mysqli_fetch_assoc($testimonial_sql)){
                    ?>
                        <div class="text-center">
                            <i class="fa fa-3x fa-quote-left text-primary mb-4"></i>
                            <h4 class="font-weight-normal mb-4"><?php echo $testimonial_row["testimoni_des"];?></h4>
                            <img class="img-fluid mx-auto mb-3"
                                src="./login/upload/<?php echo $testimonial_row["testimoni_img"];?>" alt="">
                            <h5 class="m-0"><?php echo $testimonial_row["testimoni_name"];?></h5>
                            <span><?php echo $testimonial_row["testimoni_designation"];?></span>
                        </div>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Testimonial End -->


    <?php include("./include/footer.php");?>
    <?php include("./include/js.php");?>
</body>

</html>