<?php
    session_start();
    include "../db.php";
    date_default_timezone_set('Asia/Kolkata');
    $currentTime = date('M j, Y g:i a');

    if ( !isset($_SESSION['uid']) && !isset($_SESSION['uref']) && !isset($_SESSION['utype']) )
        header("Location: logout.php");

    if ( $_SESSION['utype'] != 'master_admin' && $_SESSION['uref'] != 'fssdf4543frts' ) {
        header("Location: logout.php");
        exit();
    }
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include "includes/meta.php"; ?>
    <?php include "includes/css.php"; ?>
</head>

<body id="page-top" class="mt-55">

    <div style="margin-top: 120px;"></div>

    <?php include "includes/header.php"; ?>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <?php
                    if ( isset($_GET["edit_id"]) ) {
                        $edit_run = mysqli_query($con, "SELECT * FROM slider WHERE s_id = '$_GET[edit_id]'");
                        $edit_row = mysqli_fetch_assoc($edit_run);
                ?>
                <div class="card shadow mt-3">
                    <h5 class="card-header text-dark  text-center font-weight-bold"> Slider</h5>
                    <div class="card-body">
                        <form class="user" method="post" enctype="multipart/form-data">
                            <h4 class="mb-3 badge badge-secondary">Edit Slider Details</h4>
                            <div class="user-img">
                                <img id="selectedImage" src="<?php echo $edit_row["s_img"]; ?>"
                                    alt="example placeholder" style="max-width: 100%; height: 180px;" />
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label for="name">Slider Name</label>
                                    <input type="text" class="form-control form-control-sm mb-2" id="s_name"
                                        value="<?php echo $edit_row["s_name"];?>" name="s_name" required>
                                </div>
                                <div class="col-sm-3 mb-1 mb-sm-0">
                                    <label for="image">Slider Image</label>
                                    <input type="file" class="form-control" id="customFile1" name="slider"
                                        onchange="displaySelectedImage(event, 'selectedImage')" />
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-9">
                                    <label for="url">Slider Url</label>
                                    <input type="text" class="form-control form-control-sm mb-2" id="s_url"
                                        Value="<?php echo $edit_row["s_url"];?>" name="s_url">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label for="about">Slider About</label>
                                    <textarea class="form-control form-control-sm mb-2" id="s_about" name="s_about"
                                        rows="5"><?php echo htmlspecialchars($edit_row["s_about"]); ?></textarea>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary btn-user m-2" name="update_slider">
                                <i class="far fa-user"></i> &nbsp; Update Slider
                            </button>
                            <a href="add-slider.php" class="btn btn-warning btn-user m-2"> <i class="fas fa-ban"></i>
                                Cancel </a>
                        </form>
                    </div>
                </div>
                <?php
                    } else {
                ?>
                <?php
                    if ( isset($_GET["see_id"]) ) {
                        $see_run = mysqli_query($con, "SELECT * FROM slider WHERE  s_id = '$_GET[see_id]'");
                        $see_row = mysqli_fetch_assoc($see_run);
                ?>
                <div class="mt-3">
                    <h5 class="text-dark  text-center font-weight-bold"> Slider</h5>
                    <div class="card-body">
                        <h4 class="mb-3 badge badge-secondary">View Slider Details</h4>
                        <div class="form-group row">
                            <div class="col-sm-3 mb-1 mb-sm-0">
                            </div>
                            <div class="col-sm- mb-1 mb-sm-0">
                                <img src="<?php echo $see_row["s_img"]; ?>" alt="Smiley face" height="auto"
                                    width="100%">
                                <br> Slider Name - <?php echo $see_row["s_name"]; ?>
                                <br>
                                <br>
                                Slider About - <?php echo $see_row["s_about"]; ?><br>
                                <br>
                                Slider Url - <a
                                    href="<?php echo $see_row["s_url"]; ?>"><?php echo $see_row["s_url"]; ?></a><br>
                                <br>
                                <a href="add-slider.php" class="btn btn-warning btn-user m-2">
                                    <i class="fas fa-ban"></i> Back </a> &nbsp;
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                    } else {
                ?>
                <div class="card shadow mt-3">
                    <h5 class="card-header text-dark  text-center font-weight-bold"> Slider</h5>
                    <div class="card-body">
                        <form class="user" method="post" enctype="multipart/form-data">
                            <h4 class="mb-3 badge badge-secondary">Add New Slider</h4>
                            <div class="user-img">
                                <img id="selectedImage" src="../upload/slider/img.png" alt="example placeholder"
                                    style="max-width: 100%; height: 180px;" />
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label for="name">Slider Name</label>
                                    <input type="text" class="form-control form-control-sm mb-2" id="s_name"
                                        placeholder="Slider name *" name="s_name" required>
                                </div>
                                <div class="col-sm-3 mb-1 mb-sm-0">
                                    <label for="image">Slider Image</label>
                                    <input type="file" class="form-control" id="customFile1" name="slider"
                                        onchange="displaySelectedImage(event, 'selectedImage')" required />
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-9">
                                    <label for="url">Slider Url</label>
                                    <input type="text" class="form-control form-control-sm mb-2" id="s_url"
                                        placeholder="Slider url *" name="s_url">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label for="about">Slider About</label>
                                    <textarea class="form-control form-control-sm mb-2" id="s_about"
                                        placeholder="Slider about *" name="s_about" rows="5"></textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12">
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary btn-user m-2" name="add_slider">
                                <i class="far fa-user"></i> &nbsp; Add New Slider
                            </button>
                            <a href="add-slider.php" class="btn btn-warning btn-user m-2"> <i class="fas fa-ban"></i>
                                Cancel </a>
                        </form>
                    </div>
                </div>
                <?php
                    }
                    }
                ?>
            </div>
        </div>
    </div>
    <div style="margin-top: 120px;">
        <div class="container">
            <div class="card m-2" style="width:100%">
                <h5 class="card-header text-dark  text-center font-weight-bold">WallPaper Slider</h5>
                <?php
                    $details_sql = mysqli_query($con, "SELECT * FROM slider WHERE s_recycle = '1'  ORDER BY s_id DESC ");
                    while($details_row = mysqli_fetch_assoc($details_sql)){
                        $details_row["s_name"];
                ?>
                <div class="slider mb-2 mt-2">
                    <div class="row">
                        <div class="col-md-4 d-flex justify-content-center">
                            <img src="<?php echo $details_row["s_img"];?>" class="img-fluid" style="height:100px;"
                                alt="">
                        </div>
                        <div class="col-md-6 mb-3">
                            <p><strong>Slider Name : </strong><?php echo $details_row["s_name"];?></p>
                            <p class="m-0"><strong>Slider Details :
                                </strong><?php echo $details_row["s_about"];?></p>
                        </div>
                        <div class="col-md-2 d-flex">
                            <div>
                                <a href="add-slider.php?see_id=<?php echo $details_row["s_id"];?>"
                                    class="m-2 btn btn-warning btn-sm" style="width:35px;" title="Click to view"><i
                                        class="fa fa-eye" aria-hidden="true" style="font-size:17px;"></i>
                                </a>
                            </div>
                            <div>
                                <a href="add-slider.php?edit_id=<?php echo $details_row["s_id"];?>"
                                    class="m-2 btn btn-success btn-sm" style="width:35px;" title="Click to Edit"><i
                                        class="fa fa-pencil-square-o" aria-hidden="true" style="font-size:17px;"></i>
                                </a>
                            </div>
                            <div>
                                <a href="add-slider.php?del_id=<?php echo $details_row["s_id"];?>"
                                    class="delete m-2 btn btn-danger btn-sm" style="width:35px;"
                                    title="Click to Delete"><i class="fa fa-trash" aria-hidden="true"
                                        style="font-size:19px;"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                    }
                ?>
            </div>
        </div>
    </div>
    <div style="margin-top: 90px;"></div>
    <?php include "includes/footer.php"; ?>
    <?php include "includes/js.php"; ?>
    <script>
    CKEDITOR.replace('content', {
        height: 300,
        filebrowserUploadUrl: "upload.php"
    });
    </script>
    <script>
    function displaySelectedImage(event, elementId) {
        const selectedImage = document.getElementById(elementId);
        const fileInput = event.target;

        if (fileInput.files && fileInput.files[0]) {
            const reader = new FileReader();

            reader.onload = function(e) {
                selectedImage.src = e.target.result;
            };

            reader.readAsDataURL(fileInput.files[0]);
        }
    }
    </script>

</body>

</html>


<?php
    if(isset($_POST['add_slider'])){
        $s_name = mysqli_real_escape_string($con, strip_tags($_POST['s_name']));
        $s_about = mysqli_real_escape_string($con, strip_tags($_POST['s_about']));
        $s_url = mysqli_real_escape_string($con, strip_tags($_POST['s_url']));
        $s_position = mysqli_real_escape_string($con, strip_tags($_POST['s_position']));

        $recycle = "1";
        $created_by = $_SESSION['utype'];

        if( !empty($_FILES["slider"]["name"]) && isset($_FILES) ){
            $filetmp = $_FILES["slider"]["tmp_name"];
            $filename = $_FILES["slider"]["name"];
            $filetype = $_FILES["slider"]["type"];
            $fileerror = $_FILES["slider"]["error"];
            $filesize = $_FILES["slider"]["size"];
            $fileExt = explode('.', $filename);
            $fileActualExt = strtolower(end($fileExt));
            $fileNewName = time().".".$fileActualExt;
            $allowed = array('jpg', 'jpeg', 'pdf', 'png');
            if ( $filesize == 0 || $filesize > 100000000 ) {
                // echo "<pre>";print_r($filesize);exit();
                ?>
<script>
alert("Max File Size 1 mb");
window.location = "add-slider.php";
</script>
<?php
            } else {
                if ( in_array($fileActualExt, $allowed) ) {

                    $ulogo_upl_path = "../upload/slider/".$fileNewName;

                    move_uploaded_file($filetmp, $ulogo_upl_path);
                }
                else {
                    ?>
<script>
alert("Upload PDF / JPG / JPEG / PNG Image");
window.location = "add-slider.php";
</script>
<?php
                }
            }
        }

            $ins_sql = "INSERT INTO slider (s_name, s_position, s_img, s_recycle, s_creatdate, s_about, s_url) 
            VALUES ('$s_name', '$s_position', '$ulogo_upl_path', '$recycle', '$currentTime', '$s_about', '$s_url')";

            if(mysqli_query($con, $ins_sql)){
                ?>
<script>
window.location = 'add-slider.php';
</script>
<?php
            }
            else{
                ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'add-slider.php';
}, 1200);
</script>
<?php
            }
        } 

?>

<?php
    if ( isset($_GET["del_id"]) ) {

        $del_sql = "DELETE FROM slider WHERE s_id = '$_GET[del_id]'";

        if ( mysqli_query($con, $del_sql) ) {
            ?>
<script>
window.location = "add-slider.php";
</script>
<?php
        } else {
            ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'add-slider.php';
}, 1200);
</script>
<?php
        }
        
    }
?>

<?php
if(isset($_POST['update_slider'])) {
    $edit_id = $_GET['edit_id'];
    $s_name = mysqli_real_escape_string($con, strip_tags($_POST['s_name']));
    $s_about = mysqli_real_escape_string($con, strip_tags($_POST['s_about']));
    $s_url = mysqli_real_escape_string($con, strip_tags($_POST['s_url']));
    $s_position = mysqli_real_escape_string($con, strip_tags($_POST['s_position']));


    // Check if logo file is uploaded
    if (!empty($_FILES["slider"]["name"]) && isset($_FILES)) {
        // Retrieve previous image path
        $prev_image_query = mysqli_query($con, "SELECT s_img FROM slider WHERE s_id = '$edit_id'");
        if ($prev_image_row = mysqli_fetch_assoc($prev_image_query)) {
            $prev_image_path = $prev_image_row['s_img'];

            // Delete previous image file
            unlink($prev_image_path);
        }

        // Upload new image
        $filetmp = $_FILES["slider"]["tmp_name"];
        $filename = $_FILES["slider"]["name"];
        $filetype = $_FILES["slider"]["type"];
        $fileerror = $_FILES["slider"]["error"];
        $filesize = $_FILES["slider"]["size"];
        $fileExt = explode('.', $filename);
        $fileActualExt = strtolower(end($fileExt));
        $fileNewName = time() . "." . $fileActualExt;
        $allowed = array('jpg', 'jpeg', 'pdf', 'png');

        if ($filesize == 0 || $filesize > 100000000) {
            ?>
<script>
alert("Max File Size 1 mb");
window.location = "add-slider.php?edit_id=<?php echo $edit_id; ?>";
</script>
<?php
            exit; // Stop execution after displaying the alert
        } else {
            if (in_array($fileActualExt, $allowed)) {
                $ulogo_upl_path = "../upload/slider/" . $fileNewName;
                move_uploaded_file($filetmp, $ulogo_upl_path);
            } else {
                ?>
<script>
alert("Upload PDF / JPG / JPEG / PNG Image");
window.location = "add-slider.php?edit_id=<?php echo $edit_id; ?>";
</script>
<?php
                exit; // Stop execution after displaying the alert
            }
        }
    } else {
        // If no new image is uploaded, retain the previous image path
        $prev_image_path_query = mysqli_query($con, "SELECT s_img FROM slider WHERE s_id = '$edit_id'");
        if ($prev_image_path_row = mysqli_fetch_assoc($prev_image_path_query)) {
            $ulogo_upl_path = $prev_image_path_row['s_img'];
        }
    }

    // Update doctor information in the database
    $update_sql = "UPDATE slider SET s_name = '$s_name', s_position = '$s_position', s_img = '$ulogo_upl_path', s_about = '$s_about', s_url = '$s_url' WHERE s_id = '$edit_id'";

    if(mysqli_query($con, $update_sql)) {
        ?>
<script>
window.location = 'add-slider.php';
</script>
<?php
    } else {
        ?>
<script>
alert('Error updating doctor information.');
window.location = 'add-slider.php?edit_id=<?php echo $edit_id?>';
</script>
<?php
    }
}
?>