<?php
    session_start();
    include "../db.php";
    date_default_timezone_set('Asia/Kolkata');
    $currentTime = date('M j, Y g:i a');

    if ( !isset($_SESSION['uid']) && !isset($_SESSION['uref']) && !isset($_SESSION['utype']) )
        header("Location: logout.php");

    if ( $_SESSION['utype'] != 'master_admin' && $_SESSION['uref'] != 'fssdf4543frts' ) {
        header("Location: logout.php");
        exit();
    }
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include "includes/meta.php"; ?>
    <?php include "includes/css.php"; ?>
</head>

<body id="page-top" class="mt-55">

    <div style="margin-top: 120px;"></div>

    <?php include "includes/header.php"; ?>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow mt-3">
                    <h5 class="card-header text-dark  text-center font-weight-bold">Our Admission</h5>
                    <div class="card-body">
                        <?php
                            $sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'admission process' AND data_recycle = '1' ");
                            if($row = mysqli_fetch_assoc($sql)){
                                ?>
                        <form action="" method="POST" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-sm-6 mb-1 mb-sm-0">
                                    Qualifying Entrance Examination <br>
                                    <textarea name="content_two" class="form-control ckeditor"
                                        id="content_two"><?php echo $row["data_seo_tag"];?></textarea>
                                </div>
                                <div class="col-sm-6 mb-1 mb-sm-0">
                                    Admission Form Pdf OR Image <br>
                                    <div id="imageContainer">
                                        <?php
                                            // Assuming $row["data_img"] contains the file path stored in the database
                                            $file_path = $row["data_img"];
                                            $file_extension = pathinfo($file_path, PATHINFO_EXTENSION);
                                        ?>

                                        <?php if ($file_extension === "pdf"): ?>
                                        <embed id="selectedPdf" src="<?php echo $file_path; ?>" type="application/pdf"
                                            style="max-width: 100%; max-height: 430px;">
                                        <?php else: ?>
                                        <img id="selectedImage" src="<?php echo $file_path; ?>" alt="Selected File"
                                            style="max-width: 100%; max-height: 430px;">
                                        <?php endif; ?>
                                        <img id="selectedImage" src="<?php echo $row["data_img"];?>" alt="Selected File"
                                            style="display: none; max-width: 100%; max-height: 430px;">
                                        <embed id="selectedPdf" src="<?php echo $row["data_img"];?>"
                                            type="application/pdf" style="display: none; width: 100%; height: 430px;">
                                    </div>
                                    <input type="file" class="form-control" id="customFile1" name="ulogo"
                                        accept=".pdf, .jpg, .jpeg, .png" onchange="displaySelectedFile(event)">
                                </div>

                                <div class="col-sm-12 mb-1 mb-sm-0">
                                    Qualifying Entrance Examination <br>
                                    <textarea name="content" class="form-control ckeditor"
                                        id="content"><?php echo $row["data_long_des"];?></textarea>
                                </div>
                            </div>
                            <input type="hidden" name="edit_id" value="<?php echo $row["data_sl_no"];?>">
                            <button type="submit" class="btn btn-primary btn-user m-2" name="edit_admission_process">
                                <i class="far fa-user"></i> &nbsp; Edit Admission Process About
                            </button>
                        </form>
                        <?php
                            } else{
                            ?>
                        <form action="" method="POST" enctype="multipart/form-data">
                            <div class="row">
                                <div class="col-sm-6 mb-1 mb-sm-0">
                                    Qualifying Entrance Examination <br>
                                    <textarea name="content_two" class="form-control ckeditor"
                                        id="content_two"></textarea>
                                </div>
                                <div class="col-sm-6 mb-1 mb-sm-0">
                                    Admission Form Pdf OR Image <br>
                                    <div id="imageContainer">
                                        <img id="selectedImage" src="#" alt="Selected File"
                                            style="display: none; max-width: 100%; max-height: 430px;">
                                        <embed id="selectedPdf" src="#" type="application/pdf"
                                            style="display: none; width: 100%; height: 430px;">
                                    </div>
                                    <input type="file" class="form-control" id="customFile1" name="ulogo"
                                        accept=".pdf, .jpg, .jpeg, .png" onchange="displaySelectedFile(event)">
                                </div>
                                <div class="col-sm-12 mb-1 mb-sm-0">
                                    Qualifying Entrance Examination <br>
                                    <textarea name="content" class="form-control ckeditor" id="content"></textarea>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary btn-user m-2" name="add_admission_process">
                                <i class="far fa-user"></i> &nbsp; Add Admission Process About
                            </button>
                        </form>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div style="margin-top: 90px;"></div>
    <?php include "includes/footer.php"; ?>
    <?php include "includes/js.php"; ?>
    <script src="./vendor/ckeditor.js"></script>
    <script src="./js/ckeditor.js"></script>

    <script>
    CKEDITOR.replace('content', {
        height: 300,
        filebrowserUploadUrl: "upload.php"
    });
    CKEDITOR.replace('content_two', {
        height: 300,
        filebrowserUploadUrl: "upload.php"
    });
    </script>

    <script>
    function displaySelectedFile(event) {
        var selectedFile = event.target.files[0];
        var fileReader = new FileReader();

        fileReader.onload = function(event) {
            var fileType = selectedFile.type;

            if (fileType.includes('image')) {
                document.getElementById('selectedPdf').style.display = 'none';
                document.getElementById('selectedImage').style.display = 'initial';
                document.getElementById('selectedImage').src = event.target.result;
            } else if (fileType === 'application/pdf') {
                document.getElementById('selectedImage').style.display = 'none';
                document.getElementById('selectedPdf').style.display = 'initial';
                document.getElementById('selectedPdf').src = event.target.result;
            } else {
                alert('Unsupported file format! Please select an image or a PDF file.');
            }
        };

        fileReader.readAsDataURL(selectedFile);
    }
    </script>
</body>

</html>

<?php
if(isset($_POST['add_admission_process'])) {
    // Handle form submission
    $content_two = $_POST['content_two'];
    $content = $_POST['content'];

    // File handling
    $uploadFolder = "../upload/notice/";
    $fileName = basename($_FILES["ulogo"]["name"]);
    $targetFilePath = $uploadFolder . $fileName;
    $fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);

    if(move_uploaded_file($_FILES["ulogo"]["tmp_name"], $targetFilePath)) {
        // Insert data into database
        $sql = "INSERT INTO data (data_seo_tag, data_long_des, data_img) VALUES ('$content_two', '$content', '$targetFilePath')";
        
        if ($con->query($sql) === TRUE) {
            echo "New record created successfully";
        } else {
            echo "Error: " . $sql . "<br>" . $con->error;
        }
    } else {
        echo "Sorry, there was an error uploading your file.";
    }
}
?>

<?php

if(isset($_POST['edit_admission_process'])) {
    // Handle form submission
    $id = $_POST['edit_id']; // Assuming you have a hidden input field in your form containing the ID of the record to update
    $content_two = $_POST['content_two'];
    $content = $_POST['content'];

    // File handling
    $uploadFolder = "../upload/notice/";
    $fileName = basename($_FILES["ulogo"]["name"]);
    $targetFilePath = $uploadFolder . $fileName;
    $fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);

    // Check if a new file is uploaded
    if(!empty($fileName)) {
        // Delete previous file if it exists
        $sql_select = "SELECT data_img FROM data WHERE data_sl_no=$id";
        $result = $con->query($sql_select);
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $previousFilePath = $row["data_img"];
            if (file_exists($previousFilePath)) {
                unlink($previousFilePath);
            }
        }
        
        if(move_uploaded_file($_FILES["ulogo"]["tmp_name"], $targetFilePath)) {
            // Update data with new file path
            $sql = "UPDATE data SET data_seo_tag='$content_two', data_long_des='$content', data_img='$targetFilePath' WHERE data_sl_no=$id";
        } else {
            echo "Sorry, there was an error uploading your file.";
        }
    } else {
        // Update data without changing file path
        $sql = "UPDATE data SET data_seo_tag='$content_two', data_long_des='$content' WHERE data_sl_no=$id";
    }

    if ($con->query($sql) === TRUE) {
        echo "Record updated successfully";
    } else {
        echo "Error updating record: " . $con->error;
    }
}
?>