<?php
    session_start();
    include "../db.php";
    date_default_timezone_set('Asia/Kolkata');
    $currentTime = date('M j, Y g:i a');

    if ( !isset($_SESSION['uid']) && !isset($_SESSION['uref']) && !isset($_SESSION['utype']) )
        header("Location: logout.php");

    if ( $_SESSION['utype'] != 'master_admin' && $_SESSION['uref'] != 'fssdf4543frts' ) {
        header("Location: logout.php");
        exit();
    }
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include "includes/meta.php"; ?>
    <?php include "includes/css.php"; ?>
</head>

<body id="page-top" class="mt-55">

    <div style="margin-top: 120px;"></div>

    <?php include "includes/header.php"; ?>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card shadow mt-3">
                    <h5 class="card-header text-dark  text-center font-weight-bold">Notice</h5>
                    <div class="card-body">
                        <?php
                            if ( isset($_GET["edit_id"]) ) {
                                $edit_run = mysqli_query($con, "SELECT * FROM notice WHERE notice_id = '$_GET[edit_id]'");
                                $edit_row = mysqli_fetch_assoc($edit_run);
                        ?>
                        <form class="user" method="post" enctype="multipart/form-data">
                            <h4 class="mb-3 badge badge-secondary">Edit notice Details</h4>
                            <div class="form-group row" style="position:relative;">
                                <div class="col-md-12">
                                    Notice Name <br>
                                    <input type="text" class="form-control form-control-sm mb-2" id="notice_name"
                                        value="<?php echo $edit_row["notice_name"]?>" name="notice_name">
                                </div>
                                <div class="col-md-6">
                                    Notice Short Description <br>
                                    <textarea name="notice_short_des" id="" class="form-control"
                                        rows="14"><?php echo $edit_row["notice_short_des"];?></textarea>
                                </div>
                                <div class="col-md-6">
                                    PDF <br>
                                    <embed id="selectedImage" src="<?php if(!empty($edit_row["notice_pdf"])){
                                    echo $edit_row["notice_pdf"]; 
                                }else{?> ../upload/notice/sample.pdf <?php }?>" type="application/pdf" width="100%"
                                        height="250px" />
                                    <div class="mt-4">
                                        <input type="file" class="form-control" id="customFile1" name="ulogo"
                                            onchange="displaySelectedImage(event, 'selectedImage')" />
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary btn-user m-2" name="edit_notice">
                                    <i class="far fa-user"></i> &nbsp; Edit Notice
                                </button>

                                <a href="notice.php" class="btn btn-warning btn-user m-2"> <i class="fas fa-ban"></i>
                                    Cancel </a>

                            </div>
                        </form>

                        <?php
                                } else {
                                    ?>

                        <?php
                        if ( isset($_GET["vm"]) ) {
                            $see_run = mysqli_query($con, "SELECT * FROM notice WHERE notice_id = '$_GET[vm]'");
                            $see_row = mysqli_fetch_assoc($see_run);
                        ?>

                        <h4 class="mb-3 badge badge-secondary"><?php echo $see_row["notice_name"]; ?> - Notice</h4>
                        <div class="form-group row">
                            <div class="col-sm-12 mb-1 mb-sm-0">
                                <br> Notice Name - <?php echo $see_row["notice_name"]; ?>
                                <br>
                                <br>
                                <embed src="<?php if(!empty($see_row["notice_pdf"])){
                                    echo $see_row["notice_pdf"]; 
                                }else{?> ../upload/notice/sample.pdf <?php }?>" type="application/pdf" width="100%"
                                    height="500px" />
                                <br>
                                <br> Notice Short Description - <?php echo $see_row["notice_short_des"]; ?> <br>
                                <br> Notice Upload Date - <?php echo $see_row["notice_creatdate"]; ?> <br>
                                <br>
                                <a href="notice.php" class="btn btn-warning btn-user m-2">
                                    <i class="fas fa-ban"></i> Back </a> &nbsp;
                            </div>
                        </div>
                        <?php
                                } else {
                                    ?>
                        <form class="user" method="post" enctype="multipart/form-data">
                            <h4 id="toggleCourse" class="mb-3 badge badge-secondary" style="cursor: pointer;">Add
                                notice
                            </h4>
                            <div class="course" style="display:none;">
                                <div class="form-group row" style="position:relative;">
                                    <div class="col-md-12">
                                        Notice Name <br>
                                        <input type="text" class="form-control form-control-sm mb-2" id="notice_name"
                                            placeholder="Name of Achievement*" name="notice_name" required>
                                    </div>
                                    <div class="col-md-6">
                                        Notice Short Description <br>
                                        <textarea name="notice_short_des" placeholder="Short Description" id=""
                                            class="form-control" rows="14"></textarea>
                                    </div>
                                    <div class="col-md-6">
                                        Upload Pdf <br>
                                        <embed id="selectedImage" src="../upload/notice/sample.pdf"
                                            type="application/pdf" width="100%" height="250px" />
                                        <input type="file" class="form-control" id="customFile1" name="ulogo"
                                            accept=".pdf" onchange="displaySelectedImage(event, 'selectedImage')" />
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary btn-user m-2" name="add_notice">
                                    <i class="far fa-user"></i> &nbsp; Add Notice
                                </button>
                                <a href="notice.php" class="btn btn-warning btn-user m-2"> <i class="fas fa-ban"></i>
                                    Cancel </a>
                            </div>
                        </form>
                        <?php
                                }
                                }
                            ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container"
        style="display:<?php echo (isset($_GET["vm"]) || isset($_GET["edit_id"])) ? "none" : "block"; ?>;">
        <div class=" row m-0" style="padding:70px 0px;">
            <?php 
                if(isset($_GET['recycle_table']))
                    {
                    ?>
            <div class="col-md-12 p-0">
                <div class="d-flex justify-content-between">
                    <div>
                        <h3>Recycle Notice List</h3>
                    </div>
                    <div>
                        <a href="notice.php" class="btn btn-primary">Active
                            Notice</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered table-sm" id="thisismytable">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Notice</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php                                     
                                $sql = "SELECT * FROM notice WHERE notice_recycle = '0' ORDER BY notice_id DESC";

                                $run = mysqli_query($con, $sql);

                                $c = 1;
                                while ( $rows = mysqli_fetch_assoc($run) ) {
                                                                                                        
                                echo "
                                <tr id='$rows[notice_id]'>
                                    <td>
                                        <span class='badge badge-info badge-pill'>$c</span>
                                    </td>
                                    <td>
                                        $rows[notice_name]
                                    </td>";
                                ?>
                            <td class='text-center align-middle'>
                                <a class="btn btn-primary" style="margin-left:5px;"
                                    href="notice.php?vm=<?php echo $rows['notice_id']; ?>">View</a>
                                <a class="btn btn-primary" style="margin-left:5px;"
                                    href="notice.php?edit_id=<?php echo $rows['notice_id']; ?>">
                                    Edit</a>

                                <a href='notice.php?rec_id=<?php echo $rows["notice_id"]; ?>'
                                    class='delete m-2 btn btn-danger btn-sm rounded-circle' title='Click to Delete'>
                                    <i class="fa fa-recycle" aria-hidden="true"></i>
                                </a>
                                <a href='notice.php?del_id=<?php echo $rows["notice_id"]; ?>'
                                    class='delete m-2 btn btn-danger btn-sm rounded-circle' title='Click to Delete'>
                                    <i class="fa fa-trash" aria-hidden="true"></i>
                                </a>
                            </td>
                            </tr>
                            <?php
                                $c++;
                                    }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php
                }
            else{
            ?>
            <div class="col-md-12 p-0">
                <div class="d-flex justify-content-between">
                    <div>
                        <h3>Active Notice List</h3>
                    </div>
                    <div>
                        <a href="notice.php?recycle_table" class="btn btn-info">Recycle
                            Notice</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover table-bordered table-sm" id="thisismytable">
                        <thead>
                            <tr>
                                <th>No.</th>
                                <th>Notice</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                $sql = "SELECT * FROM notice WHERE notice_recycle = '1' ORDER BY notice_id DESC";           
                                $run = mysqli_query($con, $sql);

                                $c = 1;
                                while ( $rows = mysqli_fetch_assoc($run) ) {
                                                                                                        
                                echo "
                                <tr id='$rows[notice_id]'>
                                    <td>
                                        <span class='badge badge-info badge-pill'>$c</span>
                                    </td>
                                    <td>
                                        $rows[notice_name]
                                    </td>";
                                ?>
                            <td class='text-center align-middle'>
                                <a class="btn btn-primary" style="margin-left:5px;"
                                    href="notice.php?vm=<?php echo $rows['notice_id']; ?>">View</a>
                                <a class="btn btn-primary" style="margin-left:5px;"
                                    href="notice.php?edit_id=<?php echo $rows['notice_id']; ?>">
                                    Edit</a>
                                <a href='notice.php?rec_id=<?php echo $rows["notice_id"]; ?>'
                                    class='delete m-2 btn btn-danger btn-sm rounded-circle' title='Click to Delete'>
                                    <i class="fa fa-recycle" aria-hidden="true"></i>
                                </a>
                            </td>
                            </tr>
                            <?php
                                $c++;
                                    }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
    <div style="margin-top: 90px;"></div>
    <?php include "includes/footer.php"; ?>
    <?php include "includes/js.php"; ?>
    <script src="./vendor/ckeditor.js"></script>
    <script src="./js/ckeditor.js"></script>

    <script>
    CKEDITOR.replace('content', {
        height: 300,
        filebrowserUploadUrl: "upload.php"
    });
    </script>

    <script>
    $(document).ready(function() {
        // Add click event listener to the toggle button
        $('#toggleCourse').click(function() {
            $('.course').toggle(); // Toggle the visibility of the course section
        });
    });
    </script>
    <script>
    function displaySelectedImage(event, elementId) {
        const selectedImage = document.getElementById(elementId);
        const fileInput = event.target;

        if (fileInput.files && fileInput.files[0]) {
            const reader = new FileReader();

            reader.onload = function(e) {
                selectedImage.src = e.target.result;
            };

            reader.readAsDataURL(fileInput.files[0]);
        }
    }
    </script>

</body>

</html>

<?php
    if(isset($_POST['add_notice'])){
        $notice_name = mysqli_real_escape_string($con, strip_tags($_POST['notice_name']));
        $notice_short_des = mysqli_real_escape_string($con, strip_tags($_POST['notice_short_des']));
        $recycle = "1";

        if( !empty($_FILES["ulogo"]["name"]) && isset($_FILES) ){
            $filetmp = $_FILES["ulogo"]["tmp_name"];
            $filename = $_FILES["ulogo"]["name"];
            $filetype = $_FILES["ulogo"]["type"];
            $fileerror = $_FILES["ulogo"]["error"];
            $filesize = $_FILES["ulogo"]["size"];
            $fileExt = explode('.', $filename);
            $fileActualExt = strtolower(end($fileExt));
            $fileNewName = time().".".$fileActualExt;
            $allowed = array('pdf');
            if ( $filesize == 0 || $filesize > 100000000 ) {
                // echo "<pre>";print_r($filesize);exit();
                ?>
<script>
alert("Max File Size 1 mb");
window.location = "notice.php";
</script>
<?php
            } else {
                if ( in_array($fileActualExt, $allowed) ) {

                    $ulogo_upl_path = "../upload/notice/".$fileNewName;

                    move_uploaded_file($filetmp, $ulogo_upl_path);
                }
                else {
                    ?>
<script>
alert("Upload PDF");
window.location = "notice.php";
</script>
<?php
                }
            }
        }


            $ins_sql = "INSERT INTO notice (notice_name, notice_pdf, notice_creatdate, notice_recycle, notice_short_des) 
            VALUES ('$notice_name', '$ulogo_upl_path', '$currentTime', '$recycle', '$notice_short_des')";

            if(mysqli_query($con, $ins_sql)){
                ?>
<script>
window.location = 'notice.php';
</script>
<?php
            }
            else{
                ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'notice.php';
}, 1200);
</script>
<?php
            }
        } 
?>



<?php
    if ( isset($_GET["del_id"]) ) {

        $del_sql = "DELETE FROM notice WHERE notice_id = '$_GET[del_id]'";

        if ( mysqli_query($con, $del_sql) ) {
            ?>
<script>
window.location = "notice.php";
</script>
<?php
        } else {
            ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'notice.php';
}, 1200);
</script>
<?php
        }
        
    }
?>

<?php
if(isset($_GET["rec_id"])) {
    // Toggle Recycle Bin
    $recycle_id = mysqli_real_escape_string($con, $_GET["rec_id"]);

    // Get the current value of achiev_recycle
    $get_recycle_sql = "SELECT notice_recycle FROM notice WHERE notice_id = '$recycle_id'";
    $get_recycle_result = mysqli_query($con, $get_recycle_sql);
    $row = mysqli_fetch_assoc($get_recycle_result);
    $current_recycle_value = $row['notice_recycle'];

    // Toggle the value (0 to 1 or 1 to 0)
    $new_recycle_value = $current_recycle_value == 1 ? 0 : 1;

    // Update the database with the new value
    $update_recycle_sql = "UPDATE notice SET notice_recycle = '$new_recycle_value' WHERE notice_id = '$recycle_id'";
    if (mysqli_query($con, $update_recycle_sql)) {
        ?>
<script>
window.location = "notice.php";
</script>
<?php
    } else {
        ?>
<script>
alert('OOPS !!!!');
setTimeout(() => {
    window.location = 'notice.php';
}, 1200);
</script>
<?php
    }
}
?>


<?php
if(isset($_POST['edit_notice'])) {
    $edit_id = $_GET['edit_id'];
    $notice_name = mysqli_real_escape_string($con, strip_tags($_POST['notice_name']));
    $notice_short_des = mysqli_real_escape_string($con, strip_tags($_POST['notice_short_des']));

    // Check if logo file is uploaded
    if (!empty($_FILES["ulogo"]["name"]) && isset($_FILES)) {
        // Retrieve previous image path
        $prev_image_query = mysqli_query($con, "SELECT notice_pdf FROM notice WHERE notice_id = '$edit_id'");
        if ($prev_image_row = mysqli_fetch_assoc($prev_image_query)) {
            $prev_image_path = $prev_image_row['notice_pdf'];

            // Check if the file exists before attempting to delete it
            if (file_exists($prev_image_path)) {
                // Attempt to delete the previous image file
                if (!unlink($prev_image_path)) {
                    // Handle unlink failure
                    echo '<script>alert("Failed to delete previous image.");</script>';
                }
            } else {
                // Handle case where the file does not exist
                echo '<script>alert("Previous image file not found.");</script>';
            }
        }

        // Upload new image
        $filetmp = $_FILES["ulogo"]["tmp_name"];
        $filename = $_FILES["ulogo"]["name"];
        $filetype = $_FILES["ulogo"]["type"];
        $fileerror = $_FILES["ulogo"]["error"];
        $filesize = $_FILES["ulogo"]["size"];
        $fileExt = explode('.', $filename);
        $fileActualExt = strtolower(end($fileExt));
        $fileNewName = time() . "." . $fileActualExt;
        $allowed = array('pdf');

        if ($filesize == 0 || $filesize > 100000000) {
            ?>
<script>
alert("Max File Size 1 mb");
window.location = "notice.php?edit_id=<?php echo $edit_id; ?>";
</script>
<?php
            exit; // Stop execution after displaying the alert
        } else {
            if (in_array($fileActualExt, $allowed)) {
                $ulogo_upl_path = "../upload/notice/" . $fileNewName;
                move_uploaded_file($filetmp, $ulogo_upl_path);
            } else {
                ?>
<script>
alert("Upload PDF");
window.location = "notice.php?edit_id=<?php echo $edit_id; ?>";
</script>
<?php
                exit; // Stop execution after displaying the alert
            }
        }
    } else {
        // If no new image is uploaded, retain the previous image path
        $prev_image_path_query = mysqli_query($con, "SELECT notice_pdf FROM notice WHERE notice_id = '$edit_id'");
        if ($prev_image_path_row = mysqli_fetch_assoc($prev_image_path_query)) {
            $ulogo_upl_path = $prev_image_path_row['notice_pdf'];
        }
    }

    // Update notice information in the database
    $update_sql = "UPDATE notice SET notice_name = '$notice_name', notice_pdf = '$ulogo_upl_path', notice_short_des = '$notice_short_des' WHERE notice_id = '$edit_id'";

    if(mysqli_query($con, $update_sql)) {
        ?>
<script>
window.location = 'notice.php';
</script>
<?php
    } else {
        ?>
<script>
alert('Error updating notice information.');
window.location = 'notice.php?edit_id=<?php echo $edit_id?>';
</script>
<?php
    }
}
?>