<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("./include/meta.php");?>
    <?php include("./include/css.php");?>
</head>

<body>
    <?php include("./include/nav.php");?>

    <!-- Header Start -->
    <div class="container-fluid page-header" style="margin-bottom: 90px;">
        <div class="container">
            <div class="d-flex flex-column justify-content-center" style="min-height: 300px">
                <h3 class="display-4 text-white text-uppercase">Training & Placement</h3>
                <div class="d-inline-flex text-white">
                    <p class="m-0 text-uppercase"><a class="text-white" href="index.php">Home</a></p>
                    <i class="fa fa-angle-double-right pt-1 px-3"></i>
                    <p class="m-0 text-uppercase">Training & Placement</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Header End -->

    <!-- Testimonial Start -->
    <div class="container-fluid">
        <div class="container">
            <div class="section-content">
                <?php
                    $single_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'single_page' AND data_recycle = '1' AND data_title = 'PLACEMENT TRAINING'");
                    if($single_row = mysqli_fetch_assoc($single_sql)){
                        $page_name = $single_row["data_title"];
                ?>
                <div class="row">
                    <div class="col-md-8">
                        <p align="justify"><?php echo $single_row["data_short_des"];?></p>
                    </div>
                    <div class="col-md-4">
                        <img src="./login/upload/about/<?php echo $single_row["data_img"]?>" alt="">
                    </div>
                    <div class="col-md-12">
                        <p align="justify"><?php echo $single_row["data_long_des"];?></p>
                    </div>
                    <div class="col-md-12">
                        <p align="justify"><?php echo $single_row["data_seo_tag"];?></p>
                    </div>
                </div>
                <?php }?>
            </div>
            <div class="open-training" style="margin:40px 0px;">
                <h2 class="mb-4">
                    Active Training Opportunity</h2>
                <div class="row">
                    <?php
                        $o_training_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'training' AND data_recycle = '1' ORDER BY data_sl_no DESC");
                        while($o_training_row = mysqli_fetch_assoc($o_training_sql)){
                    ?>
                    <div class="col-md-3 mb-5">
                        <div class="active-tp-card">
                            <div class="thumb">
                                <img class="img-fluid" src="./login/upload/<?php echo $o_training_row["data_img"];?>"
                                    alt="<?php echo $o_training_row["data_title"];?> ">
                            </div>
                            <div class="content clearfix">
                                <h4 class="name m-0">
                                    <?php echo $o_training_row["data_title"];?> </h4>
                                <p class="m-0">
                                    <small>
                                        <?php
                                            $des = $o_training_row["data_short_des"];
                                            $trimmed_des = strlen($des) > 50 ? substr($des, 0, 50) . "..." : $des;
                                            echo $trimmed_des;
                                        ?>
                                    </small>
                                </p>
                                <div class="text-center">
                                    <a class="btn btn-primary btn-sm"
                                        href="training-details.php?training_id=<?php echo $o_training_row["data_sl_no"];?>">View
                                        Details</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                </div>
            </div>
            <div class="training-partners" style="margin:40px 0px;">
                <h2 class="mb-4">
                    Training Partners</h2>
                <div class="row">
                    <?php
                        $training_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'training-placement-partner' AND data_recycle = '1' ORDER BY data_sl_no DESC");
                        while($training_row = mysqli_fetch_assoc($training_sql)){
                    ?>
                    <div class="col-md-3">
                        <div class="active-tp-card bg-fff">
                            <div class="clearfix">
                                <h4 class="m-0">
                                    <?php echo $training_row["data_title"];?> </h4>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                </div>
            </div>
            <?php
            $c_training_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'training' AND data_recycle = '0' ORDER BY data_sl_no DESC");
            if(mysqli_num_rows($c_training_sql) > 0){
            ?>
            <div class="close-training" style="margin:40px 0px;">
                <h2 class="mb-4">
                    Closed Training</h2>
                <div class="row">
                    <?php
                        while($c_training_row = mysqli_fetch_assoc($c_training_sql)){
                    ?>
                    <div class="col-md-3">
                        <div class="active-tp-card">
                            <div class="thumb">
                                <img class="img-fluid" src="./login/upload/<?php echo $c_training_row["data_img"];?>"
                                    alt="<?php echo $c_training_row["data_title"];?>">
                            </div>
                            <div class="content clearfix">
                                <h4 class="name m-0">
                                    <?php echo $c_training_row["data_title"];?>
                                </h4>
                                <h4 class="name mt-0">
                                    <small>
                                        <?php
                                            $des = $c_training_row["data_short_des"];
                                            $trimmed_des = strlen($des) > 50 ? substr($des, 0, 50) . "..." : $des;
                                            echo $trimmed_des;
                                        ?>
                                    </small>
                                </h4>
                                <div class="text-center">
                                    <a class="btn btn-primary btn-sm"
                                        href="training-details.php?training_id=<?php echo $c_training_row["data_sl_no"];?>">View
                                        Details</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                </div>
            </div>
            <?php }?>
        </div>
    </div>
    <!-- Testimonial End -->


    <?php include("./include/footer.php");?>
    <?php include("./include/js.php");?>
</body>

</html>