<!DOCTYPE html>
<html lang="en">

<head>
    <?php include("./include/meta.php");?>
    <?php include("./include/css.php");?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.0.47/jquery.fancybox.min.css" />
</head>

<body>
    <?php include("./include/nav.php");?>

    <!-- Header Start -->
    <div class="container-fluid page-header" style="margin-bottom: 90px;">
        <div class="container">
            <div class="d-flex flex-column justify-content-center" style="min-height: 300px">
                <h3 class="display-4 text-white text-uppercase">Video Gallery</h3>
                <div class="d-inline-flex text-white">
                    <p class="m-0 text-uppercase"><a class="text-white" href="index.php">Home</a></p>
                    <i class="fa fa-angle-double-right pt-1 px-3"></i>
                    <p class="m-0 text-uppercase">Gallery</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Header End -->

    <!-- Gallery start -->
    <div class="container-fluid">
        <div class="container">
            <div class="text-center mb-5">
                <h5 class="text-primary text-uppercase mb-3" style="letter-spacing: 5px;">Gallery</h5>
                <h1>Our Video Gallery</h1>
            </div>
            <div class="row">
                <?php
                    // Function to extract YouTube video ID from URL
                    function getYoutubeVideoId($url) {
                        $video_id = '';
                        // Check if URL contains 'youtube.com/embed/'
                        if (strpos($url, 'youtube.com/embed/') !== false) {
                            // Extract video ID from URL
                            $parts = parse_url($url);
                            if (isset($parts['path'])) {
                                $path_parts = explode('/', $parts['path']);
                                if (count($path_parts) > 2) {
                                    $video_id = $path_parts[2];
                                }
                            }
                        }
                        return $video_id;
                    }

                    // Execute the query to fetch video gallery data
                    $video_g_sql = mysqli_query($con, "SELECT * FROM data WHERE data_catagory = 'video gallery' AND data_recycle = '1' ORDER BY data_sl_no DESC ");

                    // Check if there are any videos in the gallery
                    if (mysqli_num_rows($video_g_sql) > 0) {
                        while ($video_g_row = mysqli_fetch_assoc($video_g_sql)) {
                            // Check if the video URL exists
                            if (!empty($video_g_row["data_short_des"])) {
                                $video_url = $video_g_row["data_short_des"];
                                $video_id = getYoutubeVideoId($video_url);
                ?>
                <div class="col-md-4">
                    <div class="thumbnail">
                        <a data-fancybox="video-gallery" href="<?php echo $video_url; ?>">
                            <?php if ($video_id): ?>
                            <img src="https://img.youtube.com/vi/<?php echo $video_id; ?>/0.jpg" class="img-fluid"
                                alt="Video Thumbnail">
                            <?php else: ?>
                            <video width="320" height="240" controls autoplay muted preload="auto" loop>
                                <source src="<?php echo $video_url; ?>#t=3" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                            <?php endif; ?>
                        </a>
                    </div>
                </div>
                <?php
                            }
                        }
                    }
                ?>
            </div>
        </div>
    </div>
    <!-- Gallery end -->


    <?php include("./include/footer.php");?>
    <?php include("./include/js.php");?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.0.47/jquery.fancybox.min.js"></script>
</body>

</html>